/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils;

import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.structure.ControlFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.ControlfieldPositionDefinition;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.MarcDefinition;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.utils.Counter;
import de.gwdg.metadataqa.marc.utils.DataElementType;
import de.gwdg.metadataqa.marc.utils.MarcTagLister;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class DataElementsStatictics {
    private static final Logger logger = Logger.getLogger(DataElementsStatictics.class.getCanonicalName());

    public static Counter<DataElementType> count() {
        Counter<DataElementType> counter = new Counter<DataElementType>();
        for (ControlfieldPositionDefinition controlfieldPositionDefinition : MarcDefinition.getLeaderPositions()) {
            counter.count(DataElementType.controlFieldPositions);
        }
        for (DataFieldDefinition dataFieldDefinition : MarcDefinition.getSimpleControlFields()) {
            counter.count(DataElementType.controlFields);
        }
        for (ControlFieldDefinition controlFieldDefinition : MarcDefinition.getComplexControlFields()) {
            counter.count(DataElementType.controlFields);
            for (List<ControlfieldPositionDefinition> controlFieldPositions : controlFieldDefinition.getControlfieldPositions().values()) {
                for (ControlfieldPositionDefinition controlFieldPosition : controlFieldPositions) {
                    counter.count(DataElementType.controlFieldPositions);
                }
            }
        }
        for (Class clazz : MarcTagLister.listTags()) {
            MarcVersion version = Utils.getVersion(clazz);
            try {
                boolean isCore;
                Method getInstance = clazz.getMethod("getInstance", new Class[0]);
                DataFieldDefinition fieldTag = (DataFieldDefinition)getInstance.invoke((Object)clazz, new Object[0]);
                boolean bl = isCore = version == MarcVersion.MARC21;
                if (isCore) {
                    counter.count(DataElementType.coreFields);
                } else {
                    counter.count(DataElementType.localFields);
                }
                for (Indicator indicator : fieldTag.getIndicators()) {
                    if (indicator == null || !StringUtils.isNotBlank((CharSequence)indicator.getLabel())) continue;
                    if (isCore) {
                        counter.count(DataElementType.coreIndicators);
                        continue;
                    }
                    counter.count(DataElementType.localIndicators);
                }
                if (fieldTag.getSubfields() != null) {
                    for (SubfieldDefinition subfield : fieldTag.getSubfields()) {
                        if (isCore) {
                            counter.count(DataElementType.coreSubfields);
                            continue;
                        }
                        counter.count(DataElementType.localSubfields);
                    }
                }
                if (!isCore || fieldTag.getVersionSpecificSubfields() == null) continue;
                for (MarcVersion localVersion : fieldTag.getVersionSpecificSubfields().keySet()) {
                    for (SubfieldDefinition subfield : fieldTag.getVersionSpecificSubfields().get((Object)localVersion)) {
                        counter.count(DataElementType.localSubfields);
                    }
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                logger.log(Level.WARNING, "error in count()", e);
            }
        }
        return counter;
    }
}

