/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags84x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag885
extends DataFieldDefinition {
    private static Tag885 uniqueInstance;

    private Tag885() {
        this.initialize();
        this.postCreation();
    }

    public static Tag885 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag885();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "885";
        this.label = "Matching Information";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd885.html";
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Matching information", "NR", "b", "Status of matching and its checking", "NR", "c", "Confidence value", "NR", "d", "Generation date", "NR", "w", "Record control number", "R", "x", "Nonpublic note", "R", "z", "Public note", "R", "0", "Authority record control number or standard number", "R", "1", "Real World Object URI", "R", "2", "Source", "NR", "5", "Institution to which field applies", "NR");
        this.getSubfield("a").setMqTag("matchingInformation");
        this.getSubfield("b").setMqTag("status");
        this.getSubfield("c").setMqTag("confidence");
        this.getSubfield("d").setMqTag("date");
        this.getSubfield("w").setMqTag("controlNumber");
        this.getSubfield("x").setMqTag("nonpublicNote");
        this.getSubfield("z").setMqTag("publicNote");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setContentParser(RecordControlNumberParser.getInstance());
        this.getSubfield("1").setMqTag("uri");
        this.getSubfield("2").setMqTag("source").setCodeList(OrganizationCodes.getInstance());
        this.getSubfield("5").setMqTag("institution");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

