/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags80x;

import de.gwdg.metadataqa.marc.EncodedValue;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.codelist.NameAndTitleAuthoritySourceCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.RelatorCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;
import de.gwdg.metadataqa.marc.definition.general.validator.ISSNValidator;
import de.gwdg.metadataqa.marc.definition.structure.ControlfieldPositionDefinition;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag800
extends DataFieldDefinition {
    private static Tag800 uniqueInstance;

    private Tag800() {
        this.initialize();
        this.postCreation();
    }

    public static Tag800 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag800();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "800";
        this.label = "Series Added Entry - Personal Name";
        this.mqTag = "SeriesAddedPersonalName";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd800.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator("Type of personal name entry element").setCodes("0", "Forename", "1", "Surname", "3", "Family name").putVersionSpecificCodes(MarcVersion.SZTE, Arrays.asList(new EncodedValue("2", "Multiple surname"))).setMqTag("type").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess, FRBRFunction.ManagementSort);
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Personal name", "NR", "b", "Numeration", "NR", "c", "Titles and other words associated with a name", "R", "d", "Dates associated with a name", "NR", "e", "Relator term", "R", "f", "Date of a work", "NR", "g", "Miscellaneous information", "R", "h", "Medium", "NR", "j", "Attribution qualifier", "R", "k", "Form subheading", "R", "l", "Language of a work", "NR", "m", "Medium of performance for music", "R", "n", "Number of part/section of a work", "R", "o", "Arranged statement for music", "NR", "p", "Name of part/section of a work", "R", "q", "Fuller form of name", "NR", "r", "Key for music", "NR", "s", "Version", "R", "t", "Title of a work", "NR", "u", "Affiliation", "NR", "v", "Volume/sequential designation", "NR", "w", "Bibliographic record control number", "R", "x", "International Standard Serial Number", "NR", "0", "Authority record control number or standard number", "R", "1", "Real World Object URI", "R", "2", "Source of heading or term", "NR", "3", "Materials specified", "NR", "4", "Relationship", "R", "5", "Institution to which field applies", "R", "6", "Linkage", "NR", "7", "Control subfield", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("7").setPositions(Arrays.asList(new ControlfieldPositionDefinition("Type of record", 0, 1).setCodes(Utils.generateCodes("a", "Language material", "c", "Notated music", "d", "Manuscript notated music", "e", "Cartographic material", "f", "Manuscript cartographic material", "g", "Projected medium", "i", "Nonmusical sound recording", "j", "Musical sound recording", "k", "Two-dimensional nonprojectable graphic", "m", "Computer file", "o", "Kit", "p", "Mixed material", "r", "Three-dimensional artifact or naturally occurring object", "t", "Manuscript language material")).setMqTag("typeOfRecord"), new ControlfieldPositionDefinition("Bibliographic level", 1, 2).setCodes(Utils.generateCodes("a", "Monographic component part", "b", "Serial component part", "c", "Collection", "d", "Subunit", "i", "Integrating resource", "m", "Monograph/item", "s", "Serial")).setMqTag("bibliographicLevel")));
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("x").setValidator(ISSNValidator.getInstance());
        this.getSubfield("a").setMqTag("personalName").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("numeration").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("titlesAndWords").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("dates").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("relatorTerm").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("f").setMqTag("dateOfAWork").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("miscellaneous").setCompilanceLevels("A");
        this.getSubfield("h").setMqTag("medium").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("j").setMqTag("attributionQualifier").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("k").setMqTag("formSubheading").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("l").setMqTag("language").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("m").setMqTag("mediumOfPerformance").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("n").setMqTag("numberOfPart").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("o").setMqTag("arrangedStatement").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("p").setMqTag("nameOfPart").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("q").setMqTag("fullerForm").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("r").setMqTag("keyForMusic").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("s").setMqTag("version").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("t").setMqTag("titleOfAWork").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("u").setMqTag("affiliation").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("v").setMqTag("volumeDesignation").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("w").setMqTag("bibliographicRecordControlNumber").setCompilanceLevels("O");
        this.getSubfield("x").setMqTag("issn").setCompilanceLevels("O");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setContentParser(RecordControlNumberParser.getInstance()).setCompilanceLevels("O");
        this.getSubfield("1").setMqTag("uri");
        this.getSubfield("2").setMqTag("source").setCodeList(NameAndTitleAuthoritySourceCodes.getInstance());
        this.getSubfield("3").setMqTag("materialsSpecified").setCompilanceLevels("O");
        this.getSubfield("4").setMqTag("relationship").setCodeList(RelatorCodes.getInstance()).setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("5").setMqTag("institutionToWhichFieldApplies");
        this.getSubfield("6").setMqTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.DNB, Arrays.asList(new SubfieldDefinition("9", "Sortierz\u00e4hlung", "R")));
        this.putVersionSpecificSubfields(MarcVersion.FENNICA, Arrays.asList(new SubfieldDefinition("9", "Artikkeli", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
        this.sourceSpecificationType = SourceSpecificationType.Subfield2;
    }
}

