/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.GenreFormCodeAndTermSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag336
extends DataFieldDefinition {
    private static Tag336 uniqueInstance;

    private Tag336() {
        this.initialize();
        this.postCreation();
    }

    public static Tag336 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag336();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "336";
        this.label = "Content Type";
        this.bibframeTag = "Content";
        this.mqTag = "ContentType";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd336.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Content type term", "R", "b", "Content type code", "R", "0", "Authority record control number or standard number", "R", "1", "Real World Object URI", "R", "2", "Source", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(GenreFormCodeAndTermSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdfs:label").setMqTag("rdf:value").setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("contentTypeCode").setCompilanceLevels("M");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setContentParser(RecordControlNumberParser.getInstance());
        this.getSubfield("1").setMqTag("uri");
        this.getSubfield("2").setBibframeTag("source").setCompilanceLevels("M");
        this.getSubfield("3").setMqTag("materialsSpecified").setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR")));
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

