/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag083
extends DataFieldDefinition {
    private static Tag083 uniqueInstance;

    private Tag083() {
        this.initialize();
        this.postCreation();
    }

    public static Tag083 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag083();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "083";
        this.label = "Additional Dewey Decimal Classification Number";
        this.mqTag = "ClassificationAdditionalDdc";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd083.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Type of edition").setCodes("0", "Full edition", "1", "Abridged edition", "7", "Other edition specified in subfield $2").setMqTag("editionType");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Classification number", "R", "c", "Classification number--Ending number of span", "R", "m", "Standard or optional designation", "NR", "q", "Assigning agency", "NR", "y", "Table sequence number for internal subarrangement or add table", "R", "z", "Table identification", "R", "2", "Edition number", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("q").setCodeList(OrganizationCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setCompilanceLevels("M");
        this.getSubfield("c").setMqTag("endingNumber").setCompilanceLevels("A");
        this.getSubfield("m").setMqTag("standard").setCompilanceLevels("M");
        this.getSubfield("q").setMqTag("source").setCompilanceLevels("O");
        this.getSubfield("y").setMqTag("tableSequenceNumber").setCompilanceLevels("A");
        this.getSubfield("z").setMqTag("tableId");
        this.getSubfield("2").setMqTag("edition").setCompilanceLevels("M");
        this.getSubfield("6").setBibframeTag("linkage").setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

