/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.codelist.ClassificationSchemeSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.parser.RecordControlNumberParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag052
extends DataFieldDefinition {
    private static Tag052 uniqueInstance;

    private Tag052() {
        this.initialize();
        this.postCreation();
    }

    public static Tag052 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag052();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "052";
        this.label = "Geographic Classification";
        this.bibframeTag = "Place";
        this.mqTag = "GeographicClassification";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd052.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Code source").setCodes(" ", "Library of Congress Classification", "1", "U.S. Dept. of Defense Classification", "7", "Source specified in subfield $2").setHistoricalCodes("0", "U.S. Dept. of Defense Classification [OBSOLETE, 2002]").setMqTag("codeSource").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Geographic classification area code", "NR", "b", "Geographic classification subarea code", "R", "d", "Populated place name", "R", "0", "Authority record control number or standard number", "R", "1", "Real World Object URI", "R", "2", "Code source", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(ClassificationSchemeSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoverySelect).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("subarea").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoverySelect).setCompilanceLevels("A");
        this.getSubfield("d").setBibframeTag("rdfs:label").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoverySelect).setCompilanceLevels("O");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setContentParser(RecordControlNumberParser.getInstance());
        this.getSubfield("1").setMqTag("uri");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.sourceSpecificationType = SourceSpecificationType.Indicator1Is7AndSubfield2;
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
        this.setHistoricalSubfields("c", "Subject (MP) [OBSOLETE]");
    }
}

