/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.MusicalCompositionSourceCodes;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag047
extends DataFieldDefinition {
    private static Tag047 uniqueInstance;

    private Tag047() {
        this.initialize();
        this.postCreation();
    }

    public static Tag047 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag047();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "047";
        this.label = "Form of Musical Composition Code";
        this.bibframeTag = "GenreForm";
        this.mqTag = "MusicalCompositionForm";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd047.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator("Source of code").setCodes(" ", "MARC musical composition code", "7", "Source specified in subfield $2").setMqTag("sourceOfCode");
        this.setSubfieldsWithCardinality("a", "Form of musical composition code", "R", "2", "Source of code", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(MusicalCompositionSourceCodes.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect).setCompilanceLevels("M");
        this.getSubfield("2").setMqTag("source").setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

