/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.validator.ISSNValidator;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag022
extends DataFieldDefinition {
    private static Tag022 uniqueInstance;

    private Tag022() {
        this.initialize();
        this.postCreation();
    }

    public static Tag022 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag022();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "022";
        this.label = "International Standard Serial Number";
        this.bibframeTag = "Issn";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd022.html";
        this.setCompilanceLevels("A", "A");
        this.ind1 = new Indicator("Level of international interest").setCodes(" ", "No level specified", "0", "Continuing resource of international interest", "1", "Continuing resource not of international interest").setMqTag("levelOfInternationalInterest").setFrbrFunctions(FRBRFunction.DiscoverySelect, FRBRFunction.ManagementProcess);
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "International Standard Serial Number", "NR", "l", "ISSN-L", "NR", "m", "Canceled ISSN-L", "R", "y", "Incorrect ISSN", "R", "z", "Canceled ISSN", "R", "2", "Source", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setValidator(ISSNValidator.getInstance());
        this.getSubfield("a").setBibframeTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("l").setBibframeTag("issnL").setCompilanceLevels("A", "A");
        this.getSubfield("m").setMqTag("canceledIssnL").setCompilanceLevels("A", "A");
        this.getSubfield("y").setMqTag("incorrect").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A", "A");
        this.getSubfield("z").setMqTag("canceled").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.setHistoricalSubfields("b", "Form of issue [OBSOLETE] [CAN/MARC only]", "c", "Price [OBSOLETE] [CAN/MARC only]");
        this.putVersionSpecificSubfields(MarcVersion.KBR, Arrays.asList(new SubfieldDefinition("*", "Link with identifier", "NR").setMqTag("link"), new SubfieldDefinition("@", "Language of field", "NR").setMqTag("language"), new SubfieldDefinition("#", "number/occurrence of field", "NR").setMqTag("number")));
    }
}

