/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.bltags;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.general.validator.RegexValidator;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag039
extends DataFieldDefinition {
    private static Tag039 uniqueInstance;

    private Tag039() {
        this.initialize();
        this.postCreation();
    }

    public static Tag039 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag039();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "039";
        this.label = "National Bibliography Issue Number";
        this.mqTag = "NationalBibliographyIssueNumber";
        this.cardinality = Cardinality.Nonrepeatable;
        this.ind1 = new Indicator("National Bibliography Issue Number").setCodes("0", "British National Bibliography or British Catalogue of Music \u2013 Interim issue", "1", "British Catalogue of Music \u2013 Annual cumulation").setMqTag("source");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "National bibliography issue number", "NR", "p", "Correction issue number", "NR");
        this.getSubfield("a").setValidator(new RegexValidator("^\\d\\d(\\d{2}|0[1-3])$")).setMqTag("nationalBibliographyIssueNumber");
        this.getSubfield("p").setValidator(new RegexValidator("^\\d\\d(\\d{2}|0[1-3])$")).setMqTag("correctionIssueNumber");
    }
}

