/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.general.indexer.subject;

import java.util.HashMap;
import java.util.Map;

public class ClassificationSchemes {
    Map<String, String> schemes = new HashMap<String, String>();
    private static ClassificationSchemes uniqueInstance;

    private void initialize() {
        this.schemes.put("Library of Congress Subject Headings", "lcsh0");
        this.schemes.put("LC subject headings for children's literature", "lcchild");
        this.schemes.put("Medical Subject Headings", "mesh");
        this.schemes.put("National Agricultural Library subject authority file", "nal");
        this.schemes.put("Source not specified", "unspec");
        this.schemes.put("Canadian Subject Headings", "cansh");
        this.schemes.put("R\u00e9pertoire de vedettes-mati\u00e8re", "rvm");
        this.schemes.put("NAL subject category code list", "nal");
        this.schemes.put("Superintendent of Documents Classification System", "sudocs");
        this.schemes.put("Government of Canada Publications: Outline of Classification", "gcp");
        this.schemes.put("Library of Congress Classification", "lcc");
        this.schemes.put("U.S. Dept. of Defense Classification", "usdodc");
        this.schemes.put("No information provided", "unspec");
        this.schemes.put("Dewey Decimal classification", "ddc");
        this.schemes.put("National Library of Medicine classification", "nlm");
        this.schemes.put("Superintendent of Documents classification", "sudocs");
        this.schemes.put("Shelving control number", "shelfcn");
        this.schemes.put("Title", "title");
        this.schemes.put("Shelved separately", "shelfs");
        this.schemes.put("Other scheme", "other");
        this.schemes.put("Universal Decimal Classification", "udc");
        this.schemes.put("Dewey Decimal Classification", "ddc");
        this.schemes.put("LC-based call number assigned by LAC", "lbbcl0");
        this.schemes.put("Complete LC class number assigned by LAC", "lbbcl1");
        this.schemes.put("Incomplete LC class number assigned by LAC", "lbbcl2");
        this.schemes.put("LC-based call number assigned by the contributing library", "lbbcl3");
        this.schemes.put("Complete LC class number assigned by the contributing library", "lbbcl4");
        this.schemes.put("Incomplete LC class number assigned by the contributing library", "lbbcl5");
        this.schemes.put("Other call number assigned by LAC", "lbbcl6");
        this.schemes.put("Other class number assigned by LAC", "lbbcl7");
        this.schemes.put("Other call number assigned by the contributing library", "lbbcl8");
        this.schemes.put("Other class number assigned by the contributing library", "lbbcl9");
        this.schemes.put("Topical term", "topical");
        this.schemes.put("Personal name", "personal");
        this.schemes.put("Corporate name", "corporate");
        this.schemes.put("Meeting name", "meeting");
        this.schemes.put("Chronological term", "chronological");
        this.schemes.put("Geographic name", "geographic");
        this.schemes.put("Genre/form term", "genre");
    }

    public String resolve(String key) {
        if (this.schemes.containsKey(key)) {
            return this.schemes.get(key);
        }
        throw new IllegalArgumentException(String.format("Key '%s' is not recognized as a classification scheme", key));
    }

    private ClassificationSchemes() {
        this.initialize();
    }

    public static ClassificationSchemes getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new ClassificationSchemes();
        }
        return uniqueInstance;
    }
}

