/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.datastore;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.common.SolrInputDocument;

public class MarcSolrClient {
    private static final Logger logger = Logger.getLogger(MarcSolrClient.class.getCanonicalName());
    private String defaultUrl = "http://localhost:8983/solr/techproducts";
    private SolrClient solr;
    private boolean trimId = false;

    public MarcSolrClient() {
        this.initialize(this.defaultUrl);
    }

    public MarcSolrClient(String url) {
        this.initialize(url);
    }

    private void initialize(String url) {
        this.solr = new HttpSolrClient.Builder(url).build();
    }

    public void indexMap(String id, Map<String, List<String>> objectMap) throws IOException, SolrServerException {
        SolrInputDocument document = new SolrInputDocument(new String[0]);
        document.addField("id", (Object)(this.trimId ? id.trim() : id));
        for (Map.Entry<String, List<String>> entry : objectMap.entrySet()) {
            Object key = entry.getKey();
            List<String> value = entry.getValue();
            if (value == null) continue;
            if (!((String)key).endsWith("_sni") && !((String)key).endsWith("_ss")) {
                key = (String)key + "_ss";
            }
            document.addField((String)key, value);
        }
        try {
            this.solr.add(document);
        }
        catch (HttpSolrClient.RemoteSolrException ex) {
            logger.log(Level.WARNING, "document", document);
            logger.log(Level.WARNING, "Commit exception", ex);
        }
    }

    public void indexDuplumKey(String id, Map<String, Object> objectMap) throws IOException, SolrServerException {
        SolrInputDocument document = new SolrInputDocument(new String[0]);
        document.addField("id", (Object)id);
        for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (!((String)key).endsWith("_sni") && !((String)key).endsWith("_ss")) {
                key = (String)key + "_ss";
            }
            document.addField((String)key, value);
        }
        try {
            this.solr.add(document);
        }
        catch (HttpSolrClient.RemoteSolrException ex) {
            logger.log(Level.WARNING, "document", document);
            logger.log(Level.WARNING, "Commit exception", ex);
        }
    }

    public void commit() {
        try {
            this.solr.commit();
        }
        catch (IOException | SolrServerException e) {
            logger.log(Level.WARNING, "commit", e);
        }
    }

    public void optimize() {
        try {
            this.solr.optimize();
        }
        catch (IOException | SolrServerException e) {
            logger.log(Level.WARNING, "optimize", e);
        }
    }

    public boolean getTrimId() {
        return this.trimId;
    }

    public void setTrimId(boolean trimId) {
        this.trimId = trimId;
    }
}

