/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.datastore;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;

public class MarcElasticsearchClient {
    private final JsonProvider jsonProvider = Configuration.defaultConfiguration().jsonProvider();
    private RestClient restClient;
    private ObjectMapper mapper;

    public MarcElasticsearchClient() {
        this.initialize("localhost", 9200);
    }

    public MarcElasticsearchClient(String host) {
        this.initialize(host, 9200);
    }

    public MarcElasticsearchClient(String host, int port) {
        this.initialize(host, port);
    }

    private void initialize(String host, int port) {
        this.mapper = new ObjectMapper();
        this.restClient = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(host, port, "http")}).build();
    }

    public HttpEntity rootRequest() throws IOException {
        Response response = this.restClient.performRequest("GET", "/", Collections.singletonMap("pretty", "true"), new Header[0]);
        return response.getEntity();
    }

    public Response indexDuplumKey(String id, Map<String, Object> document) throws IOException {
        ByteArrayEntity entity = new ByteArrayEntity(this.mapper.writeValueAsBytes(document));
        return this.restClient.performRequest("PUT", "/sub/duplum/" + id, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
    }

    public Response indexTweet(int id, String user, String message) throws IOException {
        NStringEntity entity = new NStringEntity(String.format("{\"user\" : \"%s\", \"message\" : \"%s\"}", user, message), ContentType.APPLICATION_JSON);
        return this.restClient.performRequest("PUT", "/twitter/tweet/" + id, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
    }

    public Response deleteTweet(int id) throws IOException {
        return this.restClient.performRequest("DELETE", "/twitter/tweet/" + id, Collections.emptyMap(), new Header[0]);
    }

    public int getNumberOfTweets() throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("q", "*:*");
        params.put("size", "0");
        Response response = this.restClient.performRequest("GET", "/twitter/tweet/_search", params, new Header[0]);
        Object jsonObject = this.jsonProvider.parse(EntityUtils.toString((HttpEntity)response.getEntity()));
        return (Integer)JsonPath.read((Object)jsonObject, (String)"$.hits.total", (Predicate[])new Predicate[0]);
    }
}

