/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.dao;

import de.gwdg.metadataqa.marc.dao.Leader;
import de.gwdg.metadataqa.marc.dao.MarcControlField;
import de.gwdg.metadataqa.marc.dao.MarcRecord;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.ControlValue;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.structure.ControlFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.ControlfieldPositionDefinition;
import de.gwdg.metadataqa.marc.model.SolrFieldType;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.utils.keygenerator.PositionalControlFieldKeyGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class MarcPositionalControlField
extends MarcControlField {
    protected ControlFieldDefinition definition;
    protected Map<ControlfieldPositionDefinition, String> valuesMap;
    protected List<ControlValue> valuesList;
    private Map<Integer, ControlValue> valuesByPosition = new LinkedHashMap<Integer, ControlValue>();
    protected Leader.Type recordType;

    public MarcPositionalControlField(ControlFieldDefinition definition, String content) {
        this(definition, content, null);
    }

    public MarcPositionalControlField(ControlFieldDefinition definition, String content, Leader.Type recordType) {
        super(definition, content);
        this.definition = definition;
        this.recordType = recordType;
        this.valuesMap = new LinkedHashMap<ControlfieldPositionDefinition, String>();
        this.valuesList = new ArrayList<ControlValue>();
    }

    @Override
    public void setMarcRecord(MarcRecord marcRecord) {
        super.setMarcRecord(marcRecord);
        for (ControlValue value : this.valuesList) {
            value.setMarcRecord(this.marcRecord);
        }
    }

    protected abstract void processContent();

    @Override
    public Map<String, List<String>> getKeyValuePairs(SolrFieldType type) {
        return this.getKeyValuePairs(this.definition.getTag(), this.definition.getMqTag(), type);
    }

    public Map<String, List<String>> getKeyValuePairs(String tag, String mqTag, SolrFieldType type) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        PositionalControlFieldKeyGenerator keyGenerator = new PositionalControlFieldKeyGenerator(tag, mqTag, type);
        if (this.content != null) {
            map.put(keyGenerator.forTag(), Arrays.asList(this.content));
            for (Map.Entry<ControlfieldPositionDefinition, String> entry : this.valuesMap.entrySet()) {
                ControlfieldPositionDefinition position = entry.getKey();
                String value = position.resolve(entry.getValue());
                map.put(keyGenerator.forSubfield(position), Arrays.asList(value));
            }
        }
        return map;
    }

    public Map<ControlfieldPositionDefinition, String> getMap() {
        return this.valuesMap;
    }

    public List<ControlValue> getValuesList() {
        return this.valuesList;
    }

    public String getLabel() {
        return this.definition.getLabel();
    }

    public String getTag() {
        return this.definition.getTag();
    }

    public String getMqTag() {
        return this.definition.getMqTag();
    }

    public Cardinality getCardinality() {
        return this.definition.getCardinality();
    }

    @Override
    public boolean validate(MarcVersion marcVersion) {
        boolean isValid = true;
        this.validationErrors = new ArrayList();
        if (!this.initializationErrors.isEmpty()) {
            this.validationErrors.addAll(this.initializationErrors);
        }
        for (ControlValue controlValue : this.valuesList) {
            if (controlValue.validate(marcVersion)) continue;
            this.validationErrors.addAll(controlValue.getValidationErrors());
            isValid = false;
        }
        return isValid;
    }

    @Override
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    protected void registerControlValue(ControlValue controlValue) {
        this.valuesList.add(controlValue);
        this.valuesByPosition.put(controlValue.getDefinition().getPositionStart(), controlValue);
    }

    public ControlValue getControlValueByPosition(int position) {
        return this.valuesByPosition.get(position);
    }
}

