/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.utils;

import de.gwdg.metadataqa.marc.MarcFactory;
import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.cli.processor.MarcFileProcessor;
import de.gwdg.metadataqa.marc.dao.Leader;
import de.gwdg.metadataqa.marc.dao.MarcRecord;
import de.gwdg.metadataqa.marc.definition.DataSource;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.utils.ReadMarc;
import java.io.FileInputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.time.LocalTime;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.solr.client.solrj.SolrServerException;
import org.marc4j.MarcException;
import org.marc4j.MarcReader;
import org.marc4j.marc.Record;

public class RecordIterator {
    private static final Logger logger = Logger.getLogger(RecordIterator.class.getCanonicalName());
    private final MarcFileProcessor processor;
    private int i = 0;
    private String lastKnownId = "";
    private CommonParameters parameters;
    private String replecementInControlFields;
    private MarcVersion marcVersion;
    private Leader.Type defaultRecordType;
    private DecimalFormat decimalFormat;

    public RecordIterator(MarcFileProcessor processor) {
        this.processor = processor;
    }

    public void start() {
        long start = System.currentTimeMillis();
        this.processor.beforeIteration();
        CommonParameters parameters = this.processor.getParameters();
        this.marcVersion = parameters.getMarcVersion();
        this.defaultRecordType = parameters.getDefaultRecordType();
        this.replecementInControlFields = parameters.getReplecementInControlFields();
        this.decimalFormat = new DecimalFormat();
        if (this.processor.getParameters().doLog()) {
            logger.info("marcVersion: " + this.marcVersion.getCode() + ", " + this.marcVersion.getLabel());
        }
        if (parameters.getDataSource().equals((Object)DataSource.FILE)) {
            String[] inputFileNames;
            for (String inputFileName : inputFileNames = this.processor.getParameters().getArgs()) {
                if (this.processor.readyToProcess()) {
                    this.processFile(inputFileName);
                    continue;
                }
                break;
            }
        } else if (parameters.getDataSource().equals((Object)DataSource.STREAM)) {
            try {
                MarcReader reader = this.getMarcStreamReader(this.processor.getParameters());
                this.processContent(reader, "stream");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.processor.afterIteration(this.i);
        long end = System.currentTimeMillis();
        long duration = (end - start) / 1000L;
        if (parameters.doLog()) {
            logger.info(String.format("Bye! It took: %s", LocalTime.MIN.plusSeconds(duration).toString()));
        }
    }

    private void processFile(String inputFileName) {
        Path path = Paths.get(inputFileName, new String[0]);
        String fileName = path.getFileName().toString();
        if (this.processor.getParameters().doLog()) {
            logger.info("processing: " + fileName);
        }
        try {
            this.processor.fileOpened(path);
            MarcReader reader = this.getMarcFileReader(this.processor.getParameters(), path);
            this.processContent(reader, fileName);
            if (this.processor.getParameters().doLog()) {
                logger.info(String.format("Finished processing file. Processed %s records.", this.decimalFormat.format(this.i)));
            }
        }
        catch (SolrServerException ex) {
            if (this.processor.getParameters().doLog()) {
                logger.severe(ex.toString());
            }
            System.exit(0);
        }
        catch (Exception ex) {
            if (this.processor.getParameters().doLog()) {
                logger.severe("Other exception: " + ex.toString());
                for (StackTraceElement element : ex.getStackTrace()) {
                    System.err.println(element.toString());
                }
                Throwable exa = ex;
                while (exa.getCause() != null) {
                    System.err.println("cause");
                    exa = exa.getCause();
                    for (StackTraceElement element : exa.getStackTrace()) {
                        System.err.println(element.toString());
                    }
                }
            }
            logger.log(Level.SEVERE, "start", ex);
            System.exit(0);
        }
    }

    private void processContent(MarcReader reader, String fileName) {
        while (reader.hasNext() && this.processor.readyToProcess()) {
            Record marc4jRecord = this.getNextMarc4jRecord(this.i, this.lastKnownId, reader);
            ++this.i;
            if (marc4jRecord == null || RecordIterator.isUnderOffset(this.processor.getParameters().getOffset(), this.i)) continue;
            if (RecordIterator.isOverLimit(this.processor.getParameters().getLimit(), this.i)) break;
            if (marc4jRecord.getControlNumber() == null) {
                logger.severe("No record number at " + this.i + ", last known ID: " + this.lastKnownId);
                System.err.println(marc4jRecord);
                continue;
            }
            this.lastKnownId = marc4jRecord.getControlNumber();
            if (this.skipRecord(marc4jRecord)) continue;
            try {
                this.processor.processRecord(marc4jRecord, this.i);
                MarcRecord marcRecord = MarcFactory.createFromMarc4j(marc4jRecord, this.defaultRecordType, this.marcVersion, this.replecementInControlFields);
                try {
                    this.processor.processRecord(marcRecord, this.i);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "start", e);
                }
                if (this.i % 100000 != 0 || !this.processor.getParameters().doLog()) continue;
                logger.info(String.format("%s/%s (%s)", fileName, this.decimalFormat.format(this.i), marcRecord.getId()));
            }
            catch (IllegalArgumentException e) {
                this.extracted(this.i, marc4jRecord, e, "Error (illegal argument) with record '%s'. %s");
            }
            catch (Exception e) {
                this.extracted(this.i, marc4jRecord, e, "Error (general) with record '%s'. %s");
            }
        }
    }

    private MarcReader getMarcFileReader(CommonParameters parameters, Path path) throws Exception {
        if (path.toString().endsWith(".gz")) {
            return ReadMarc.getStreamReader(parameters.getMarcFormat(), new GZIPInputStream(new FileInputStream(path.toFile())), parameters.getDefaultEncoding());
        }
        return ReadMarc.getFileReader(parameters.getMarcFormat(), path.toString(), parameters.getDefaultEncoding());
    }

    private MarcReader getMarcStreamReader(CommonParameters parameters) throws Exception {
        return ReadMarc.getStreamReader(parameters.getMarcFormat(), parameters.getStream(), parameters.getDefaultEncoding());
    }

    private Record getNextMarc4jRecord(int i, String lastKnownId, MarcReader reader) {
        Record marc4jRecord = null;
        try {
            marc4jRecord = reader.next();
        }
        catch (NegativeArraySizeException | NumberFormatException | MarcException e) {
            logger.severe(String.format("MARC record parsing problem at record #%d (last known ID: %s): %s", i + 1, lastKnownId, e.getLocalizedMessage()));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "start", e);
        }
        return marc4jRecord;
    }

    private boolean skipRecord(Record marc4jRecord) {
        return this.processor.getParameters().hasId() && !marc4jRecord.getControlNumber().trim().equals(this.processor.getParameters().getId());
    }

    private void extracted(int i, Record marc4jRecord, Exception e, String message) {
        if (marc4jRecord.getControlNumber() == null) {
            logger.severe("No record number at " + i);
        }
        if (this.processor.getParameters().doLog()) {
            logger.severe(String.format(message, marc4jRecord.getControlNumber(), e.getMessage()));
        }
        logger.log(Level.SEVERE, "start", e);
    }

    private static boolean isOverLimit(int limit, int i) {
        return limit > -1 && i > limit;
    }

    private static boolean isUnderOffset(int offset, int i) {
        return offset > -1 && i < offset;
    }

    private static void printHelp(Options opions) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java -cp metadata-qa-marc.jar de.gwdg.metadataqa.marc.cli.Validator [options] [file]", opions);
    }
}

