/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.parameters;

import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorFormat;
import java.io.Serializable;
import org.apache.commons.cli.ParseException;

public class ValidatorParameters
extends CommonParameters
implements Serializable {
    public static final String DEFAULT_FILE_NAME = "validation-report.txt";
    private String detailsFileName = "validation-report.txt";
    private String summaryFileName;
    private boolean doDetails = true;
    private boolean doSummary = false;
    private ValidationErrorFormat format = ValidationErrorFormat.TEXT;
    private boolean useStandardOutput = false;
    private boolean isOptionSet;
    private boolean emptyLargeCollectors = false;
    private boolean collectAllErrors = false;

    @Override
    protected void setOptions() {
        if (!this.isOptionSet) {
            super.setOptions();
            this.options.addOption("g", "summaryFileName", true, "the summary file name (provides a summary of issues, such as the number of instance and number of records having the particular issue)");
            this.options.addOption("s", "summary", false, "show summary instead of record level display");
            this.options.addOption("h", "details", false, "show record level display");
            this.options.addOption("f", "detailsFileName", true, String.format("the report file name (default is '%s')", DEFAULT_FILE_NAME));
            this.options.addOption("r", "format", true, "specify a format");
            this.options.addOption("w", "emptyLargeCollectors", false, "empty large collectors");
            this.options.addOption("t", "collectAllErrors", false, "collect all errors (useful only for validating small number of records)");
            this.isOptionSet = true;
        }
    }

    public ValidatorParameters() {
    }

    public ValidatorParameters(String[] arguments) throws ParseException {
        super(arguments);
        if (this.cmd.hasOption("detailsFileName")) {
            this.detailsFileName = this.cmd.getOptionValue("detailsFileName");
        }
        if (this.cmd.hasOption("summaryFileName")) {
            this.summaryFileName = this.cmd.getOptionValue("summaryFileName");
            this.doSummary = true;
        }
        if (this.detailsFileName.equals("stdout")) {
            this.useStandardOutput = true;
        }
        if (this.cmd.hasOption("format")) {
            this.setFormat(this.cmd.getOptionValue("format"));
        }
        if (this.cmd.hasOption("summary")) {
            this.doSummary = true;
            if (!this.cmd.hasOption("details")) {
                this.doDetails = false;
            }
        }
        if (this.doDetails && this.doSummary && !this.useStandardOutput && this.summaryFileName == null) {
            throw new ParseException("If the details and summary is requested, summaryFileName must be provided!");
        }
        if (this.cmd.hasOption("emptyLargeCollectors")) {
            this.emptyLargeCollectors = true;
        }
        this.setCollectAllErrors(this.cmd.hasOption("collectAllErrors"));
    }

    public String getDetailsFileName() {
        return this.detailsFileName;
    }

    public void setDetailsFileName(String detailsFileName) {
        this.detailsFileName = detailsFileName;
    }

    public boolean doSummary() {
        return this.doSummary;
    }

    public void setDoSummary(boolean doSummary) {
        this.doSummary = doSummary;
    }

    public boolean doDetails() {
        return this.doDetails;
    }

    public void setDoDetails(boolean doDetails) {
        this.doDetails = doDetails;
    }

    public boolean useStandardOutput() {
        return this.useStandardOutput;
    }

    public void setUseStandardOutput(boolean useStandardOutput) {
        this.useStandardOutput = useStandardOutput;
    }

    public ValidationErrorFormat getFormat() {
        return this.format;
    }

    public void setFormat(String format) throws ParseException {
        this.format = ValidationErrorFormat.byFormat(format);
        if (this.format == null) {
            throw new ParseException(String.format("Unrecognized ValidationErrorFormat parameter value: '%s'", format));
        }
    }

    public String getSummaryFileName() {
        return this.summaryFileName;
    }

    public void setSummaryFileName(String summaryFileName) {
        this.summaryFileName = summaryFileName;
    }

    public boolean doEmptyLargeCollectors() {
        return this.emptyLargeCollectors;
    }

    public void setEmptyLargeCollectors(boolean emptyLargeCollectors) {
        this.emptyLargeCollectors = emptyLargeCollectors;
    }

    public boolean collectAllErrors() {
        return this.collectAllErrors;
    }

    public void setCollectAllErrors(boolean collectAllErrors) {
        this.collectAllErrors = collectAllErrors;
    }

    @Override
    public String formatParameters() {
        Object text = super.formatParameters();
        text = (String)text + String.format("details: %s%n", this.doSummary);
        text = (String)text + String.format("summary: %s%n", this.doSummary);
        text = (String)text + String.format("detailsFileName: %s%n", this.detailsFileName);
        text = (String)text + String.format("summaryFileName: %s%n", this.summaryFileName);
        text = (String)text + String.format("format: %s%n", this.format.getLabel());
        text = (String)text + String.format("emptyLargeCollectors: %s%n", this.emptyLargeCollectors);
        return text;
    }
}

