/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.analysis.Serial;
import de.gwdg.metadataqa.marc.analysis.SerialFields;
import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.cli.parameters.SerialScoreParameters;
import de.gwdg.metadataqa.marc.cli.processor.MarcFileProcessor;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import de.gwdg.metadataqa.marc.dao.Leader;
import de.gwdg.metadataqa.marc.dao.MarcRecord;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.marc4j.marc.Record;

public class SerialScore
implements MarcFileProcessor,
Serializable {
    private static final Logger logger = Logger.getLogger(SerialScore.class.getCanonicalName());
    private final Options options;
    private final boolean readyToProcess;
    private SerialScoreParameters parameters;
    private File output = null;
    private Map<Integer, Integer> histogram = new HashMap<Integer, Integer>();

    public SerialScore(String[] args) throws ParseException {
        this.parameters = new SerialScoreParameters(args);
        this.options = this.parameters.getOptions();
        this.readyToProcess = true;
    }

    public static void main(String[] args) throws ParseException {
        SerialScore processor = null;
        try {
            processor = new SerialScore(args);
        }
        catch (ParseException e) {
            System.err.println("ERROR. " + e.getLocalizedMessage());
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        if (processor.getParameters().getArgs().length < 1) {
            System.err.println("Please provide a MARC file name!");
            System.exit(0);
        }
        if (processor.getParameters().doHelp()) {
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        RecordIterator iterator = new RecordIterator(processor);
        iterator.start();
    }

    @Override
    public CommonParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void beforeIteration() {
        logger.info(this.parameters.formatParameters());
        this.printFields();
        this.output = new File(this.parameters.getOutputDir(), this.parameters.getFileName());
        if (this.output.exists()) {
            this.output.delete();
        }
        this.print(Utils.createRow(Serial.getHeader()));
    }

    @Override
    public void fileOpened(Path path) {
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) {
    }

    @Override
    public void processRecord(MarcRecord marcRecord, int recordNumber) {
        if (marcRecord.getType().equals((Object)Leader.Type.CONTINUING_RESOURCES)) {
            if (this.parameters.getIgnorableRecords().isIgnorable(marcRecord)) {
                return;
            }
            Serial serial = new Serial(marcRecord);
            List<Integer> scores = serial.determineRecordQualityScore();
            String message = Utils.createRow(Utils.quote(marcRecord.getId().trim()), StringUtils.join(scores, (String)","));
            this.print(message);
        }
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
        this.printHistogram();
    }

    private void printHistogram() {
        Path path = Paths.get(this.parameters.getOutputDir(), "serial-histogram.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(Utils.createRow("score", "frequency"));
            this.histogram.entrySet().stream().sorted((e1, e2) -> ((Integer)e1.getKey()).compareTo((Integer)e2.getKey())).forEach(entry -> {
                try {
                    writer.write(Utils.createRow(entry.getKey(), entry.getValue()));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "printHistogram", e);
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "printHistogram", e);
        }
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }

    @Override
    public void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String message = String.format("java -cp metadata-qa-marc.jar %s [options] [file]", this.getClass().getCanonicalName());
        formatter.printHelp(message, options);
    }

    private void print(String message) {
        try {
            FileUtils.writeStringToFile((File)this.output, (String)message, (Charset)Charset.defaultCharset(), (boolean)true);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "print", e);
        }
    }

    private void printFields() {
        Path path = Paths.get(this.parameters.getOutputDir(), "serial-score-fields.csv");
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(Utils.createRow("name", "transformed"));
            for (SerialFields field : SerialFields.values()) {
                try {
                    writer.write(Utils.createRow(Utils.quote(field.getLabel()), field.getMachine()));
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "printFields", e);
                }
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "printFields", e);
        }
    }
}

