/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis;

import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.analysis.ThompsonTraillFields;
import de.gwdg.metadataqa.marc.analysis.ThompsonTraillScores;
import de.gwdg.metadataqa.marc.dao.Control008;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.MarcRecord;
import de.gwdg.metadataqa.marc.definition.general.codelist.CountryCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.LanguageCodes;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ThompsonTraillAnalysis {
    private static final Logger logger = Logger.getLogger(ThompsonTraillAnalysis.class.getCanonicalName());
    private static final Pattern datePattern = Pattern.compile("^(14[5-9]\\d|1[5-9]\\d\\d|200\\d|201[0-7])$");
    private static List<String> headers = new LinkedList<String>();

    private ThompsonTraillAnalysis() {
        throw new IllegalStateException("This is a utility class");
    }

    public static List<String> getHeader() {
        return headers;
    }

    public static List<Integer> getScores(MarcRecord marcRecord) {
        ThompsonTraillScores ttScores = new ThompsonTraillScores();
        ttScores.set(ThompsonTraillFields.ISBN, ThompsonTraillAnalysis.countFields(marcRecord, Arrays.asList("020")));
        ttScores.set(ThompsonTraillFields.AUTHORS, ThompsonTraillAnalysis.countFields(marcRecord, Arrays.asList("100", "110", "111")));
        ttScores.set(ThompsonTraillFields.ALTERNATIVE_TITLES, ThompsonTraillAnalysis.countFields(marcRecord, Arrays.asList("246")));
        ttScores.set(ThompsonTraillFields.EDITION, ThompsonTraillAnalysis.countFields(marcRecord, Arrays.asList("250")));
        ttScores.set(ThompsonTraillFields.CONTRIBUTORS, ThompsonTraillAnalysis.countFields(marcRecord, Arrays.asList("700", "710", "711", "720")));
        ttScores.set(ThompsonTraillFields.SERIES, ThompsonTraillAnalysis.countFields(marcRecord, Arrays.asList("440", "490", "800", "810", "830")));
        ttScores.set(ThompsonTraillFields.TOC, ThompsonTraillAnalysis.calculateTocAndAbstract(marcRecord));
        Control008 control008 = marcRecord.getControl008();
        String date008 = ThompsonTraillAnalysis.extractDate008(control008);
        ttScores.set(ThompsonTraillFields.DATE_008, ThompsonTraillAnalysis.calculateDate008(date008));
        ttScores.set(ThompsonTraillFields.DATE_26X, ThompsonTraillAnalysis.calculateDate26x(marcRecord, date008));
        ttScores.set(ThompsonTraillFields.LC_NLM, ThompsonTraillAnalysis.calculateClassificationLcNlm(marcRecord));
        ThompsonTraillAnalysis.calculateClassifications(marcRecord, ttScores);
        ttScores.set(ThompsonTraillFields.ONLINE, ThompsonTraillAnalysis.calculateIsOnlineResource(marcRecord, control008));
        ttScores.set(ThompsonTraillFields.LANGUAGE_OF_RESOURCE, ThompsonTraillAnalysis.calculateLanguageOfResource(control008));
        ttScores.set(ThompsonTraillFields.COUNTRY_OF_PUBLICATION, ThompsonTraillAnalysis.calculateCountryOfPublication(control008));
        ThompsonTraillAnalysis.calculateLanguageAndRda(marcRecord, ttScores);
        ttScores.calculateTotal();
        return ttScores.asList();
    }

    private static void calculateLanguageAndRda(MarcRecord marcRecord, ThompsonTraillScores ttScores) {
        List<DataField> fields040 = marcRecord.getDatafield("040");
        boolean noLanguageOrEnglish = false;
        boolean isRDA = false;
        if (fields040 != null && !fields040.isEmpty()) {
            for (DataField language : fields040) {
                List<MarcSubfield> subfields = language.getSubfield("b");
                if (subfields != null && !subfields.isEmpty()) {
                    for (MarcSubfield subfield : subfields) {
                        if (noLanguageOrEnglish || !subfield.getValue().equals("eng")) continue;
                        noLanguageOrEnglish = true;
                    }
                }
                if ((subfields = language.getSubfield("e")) == null || subfields.isEmpty()) continue;
                for (MarcSubfield subfield : subfields) {
                    if (isRDA || !subfield.getValue().equals("rda")) continue;
                    isRDA = true;
                }
            }
        }
        ttScores.set(ThompsonTraillFields.LANGUAGE_OF_CATALOGING, noLanguageOrEnglish ? 1 : 0);
        ttScores.set(ThompsonTraillFields.RDA, isRDA ? 1 : 0);
    }

    private static int calculateClassificationLcNlm(MarcRecord marcRecord) {
        return ThompsonTraillAnalysis.exists(marcRecord, "050") || ThompsonTraillAnalysis.exists(marcRecord, "060") || ThompsonTraillAnalysis.exists(marcRecord, "090") ? 1 : 0;
    }

    private static int calculateDate26x(MarcRecord marcRecord, String date008) {
        List<MarcSubfield> subfields;
        List<DataField> fields;
        int score = 0;
        if (ThompsonTraillAnalysis.exists(marcRecord, "260")) {
            fields = marcRecord.getDatafield("260");
            for (DataField field : fields) {
                subfields = field.getSubfield("c");
                if (subfields == null || subfields.isEmpty()) continue;
                for (MarcSubfield subfield : subfields) {
                    if (score == 0) {
                        score = 1;
                    }
                    if (score >= 2 || date008.equals("") || !subfield.getValue().contains(date008)) continue;
                    score = 2;
                }
            }
        }
        if (ThompsonTraillAnalysis.exists(marcRecord, "264")) {
            fields = marcRecord.getDatafield("264");
            for (DataField field : fields) {
                subfields = field.getSubfield("c");
                if (subfields == null || subfields.isEmpty()) continue;
                for (MarcSubfield subfield : subfields) {
                    if (score == 0) {
                        score = 1;
                    }
                    if (score >= 2 || date008.equals("") || !subfield.getValue().contains(date008)) continue;
                    score = 2;
                }
            }
        }
        return score;
    }

    private static String extractDate008(Control008 control008) {
        String date008 = "";
        if (control008 != null && control008.getTag008all07() != null) {
            date008 = control008.getTag008all07().getValue();
        }
        return date008;
    }

    private static int calculateDate008(String date008) {
        return datePattern.matcher(date008).matches() ? 1 : 0;
    }

    private static int calculateTocAndAbstract(MarcRecord marcRecord) {
        int score = 0;
        score += ThompsonTraillAnalysis.exists(marcRecord, "505") ? 1 : 0;
        return score += ThompsonTraillAnalysis.exists(marcRecord, "520") ? 1 : 0;
    }

    private static void calculateClassifications(MarcRecord marcRecord, ThompsonTraillScores ttScores) {
        for (String tag : Arrays.asList("600", "610", "611", "630", "650", "651", "653")) {
            if (!ThompsonTraillAnalysis.exists(marcRecord, tag)) continue;
            List<DataField> fields = marcRecord.getDatafield(tag);
            for (DataField field : fields) {
                if (field.getInd2().equals("0")) {
                    ttScores.count(ThompsonTraillFields.LC_NLM);
                    continue;
                }
                if (field.getInd2().equals("2")) {
                    ttScores.count(ThompsonTraillFields.MESH);
                    continue;
                }
                if (field.getInd2().equals("7")) {
                    List<MarcSubfield> subfield2 = field.getSubfield("2");
                    if (subfield2 == null) {
                        logger.severe(String.format("Error in %s: ind2 = 7, but there is no $2", marcRecord.getControl001().getContent()));
                        continue;
                    }
                    switch (field.getSubfield("2").get(0).getValue()) {
                        case "fast": {
                            ttScores.count(ThompsonTraillFields.FAST);
                            break;
                        }
                        case "gnd": {
                            ttScores.count(ThompsonTraillFields.GND);
                            break;
                        }
                        default: {
                            ttScores.count(ThompsonTraillFields.OTHER);
                        }
                    }
                    continue;
                }
                ttScores.count(ThompsonTraillFields.OTHER);
            }
        }
    }

    private static int calculateIsOnlineResource(MarcRecord marcRecord, Control008 control008) {
        int score008 = ThompsonTraillAnalysis.calculateIsOnlineFrom008(marcRecord, control008);
        int score300a = ThompsonTraillAnalysis.calculateIsOnlineFrom300a(marcRecord);
        return score008 + score300a;
    }

    private static int calculateIsOnlineFrom300a(MarcRecord marcRecord) {
        List<DataField> fields300 = marcRecord.getDatafield("300");
        boolean isOnlineResource = false;
        if (fields300 != null && !fields300.isEmpty()) {
            for (DataField field : fields300) {
                List<MarcSubfield> subfields = field.getSubfield("a");
                if (subfields == null || subfields.isEmpty()) continue;
                for (MarcSubfield subfield : subfields) {
                    if (isOnlineResource || !subfield.getValue().equals("online resource")) continue;
                    isOnlineResource = true;
                }
            }
        }
        return isOnlineResource ? 1 : 0;
    }

    private static int calculateIsOnlineFrom008(MarcRecord marcRecord, Control008 control008) {
        String formOfItem = null;
        if (control008 != null) {
            switch (marcRecord.getType()) {
                case BOOKS: {
                    if (control008.getTag008book23() == null) break;
                    formOfItem = control008.getTag008book23().getValue();
                    break;
                }
                case COMPUTER_FILES: {
                    if (control008.getTag008computer23() == null) break;
                    formOfItem = control008.getTag008computer23().getValue();
                    break;
                }
                case CONTINUING_RESOURCES: {
                    if (control008.getTag008continuing23() == null) break;
                    formOfItem = control008.getTag008continuing23().getValue();
                    break;
                }
                case MAPS: {
                    if (control008.getTag008map29() == null) break;
                    formOfItem = control008.getTag008map29().getValue();
                    break;
                }
                case MIXED_MATERIALS: {
                    if (control008.getTag008mixed23() == null) break;
                    formOfItem = control008.getTag008mixed23().getValue();
                    break;
                }
                case MUSIC: {
                    if (control008.getTag008music23() == null) break;
                    formOfItem = control008.getTag008music23().getValue();
                    break;
                }
                case VISUAL_MATERIALS: {
                    if (control008.getTag008visual29() == null) break;
                    formOfItem = control008.getTag008visual29().getValue();
                }
            }
        }
        return formOfItem != null && formOfItem.equals("o") ? 1 : 0;
    }

    private static int calculateLanguageOfResource(Control008 control008) {
        int score = control008 != null && control008.getTag008all35() != null ? (LanguageCodes.getInstance().isValid(control008.getTag008all35().getValue()) ? 1 : 0) : 0;
        return score;
    }

    private static int calculateCountryOfPublication(Control008 control008) {
        int score = control008 != null && control008.getTag008all15() != null ? (CountryCodes.getInstance().isValid(control008.getTag008all15().getValue()) ? 1 : 0) : 0;
        return score;
    }

    private static Integer getTotal(List<Integer> scores) {
        int total = 0;
        for (Integer score : scores) {
            total += score.intValue();
        }
        return total;
    }

    private static boolean exists(MarcRecord marcRecord, String tag) {
        List<DataField> fields = marcRecord.getDatafield(tag);
        return fields != null && !fields.isEmpty();
    }

    private static int countFields(MarcRecord marcRecord, List<String> tags) {
        int counter = 0;
        for (String tag : tags) {
            if (!ThompsonTraillAnalysis.exists(marcRecord, tag)) continue;
            counter += marcRecord.getDatafield(tag).size();
        }
        return counter;
    }

    static {
        for (ThompsonTraillFields field : ThompsonTraillFields.values()) {
            headers.add(field.getMachine());
        }
    }
}

