/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis;

import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.MarcRecord;
import java.util.HashSet;
import java.util.Set;

public class NetworkAnalyzer {
    private final MarcRecord marcRecord;
    private final Set<DataField> collector;

    public NetworkAnalyzer(MarcRecord marcRecord) {
        this.marcRecord = marcRecord;
        this.collector = new HashSet<DataField>();
    }

    public Set<DataField> process(int recordNumber) {
        for (DataField field : this.marcRecord.getAuthorityFields()) {
            this.register(field, recordNumber);
        }
        for (DataField field : this.marcRecord.getSubjects()) {
            this.register(field, recordNumber);
        }
        return this.collector;
    }

    private void register(DataField field, int recordNumber) {
        if (!this.collector.contains(field)) {
            this.collector.add(field);
        }
    }
}

