/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis;

import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.analysis.ClassificationStatistics;
import de.gwdg.metadataqa.marc.analysis.FieldWithScheme;
import de.gwdg.metadataqa.marc.cli.utils.Schema;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.MarcRecord;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.ClassificationSchemes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ClassificationAnalyzer {
    private static final Logger logger = Logger.getLogger(ClassificationAnalyzer.class.getCanonicalName());
    private static final ClassificationSchemes classificationSchemes = ClassificationSchemes.getInstance();
    private static final Pattern NUMERIC = Pattern.compile("^\\d");
    private final ClassificationStatistics statistics;
    private MarcRecord marcRecord;
    private List<Schema> schemasInRecord;
    private static final List<String> fieldsWithIndicator1AndSubfield2 = Arrays.asList("052", "086");
    private static final List<String> fieldsWithIndicator2AndSubfield2 = Arrays.asList("055", "072", "600", "610", "611", "630", "647", "648", "650", "651", "655", "656", "657");
    private static final List<String> fieldsWithSubfield2 = Arrays.asList("084", "654", "658", "662");
    private static final List<String> fieldsWithoutSource = Arrays.asList("653");
    private static final List<FieldWithScheme> fieldsWithScheme = Arrays.asList(new FieldWithScheme("080", "Universal Decimal Classification"), new FieldWithScheme("082", "Dewey Decimal Classification"), new FieldWithScheme("083", "Dewey Decimal Classification"), new FieldWithScheme("085", "Dewey Decimal Classification"));

    public ClassificationAnalyzer(MarcRecord marcRecord, ClassificationStatistics statistics) {
        this.marcRecord = marcRecord;
        this.statistics = statistics;
    }

    public int process() {
        int total = 0;
        this.schemasInRecord = new ArrayList<Schema>();
        total = this.processFieldsWithIndicator1AndSubfield2(total);
        total = this.processFieldsWithIndicator2AndSubfield2(total);
        total = this.processFieldsWithSubfield2(total);
        total = this.processFieldsWithoutSource(total);
        total = this.processFieldsWithScheme(total);
        this.increaseCounters(total);
        return total;
    }

    private void increaseCounters(int total) {
        Utils.count(total > 0, this.statistics.getHasClassifications());
        Utils.count(total, this.statistics.getSchemaHistogram());
        this.statistics.getFrequencyExamples().computeIfAbsent(total, s -> this.marcRecord.getId(true));
        List<String> collocation = this.getCollocationInRecord();
        if (!collocation.isEmpty()) {
            Utils.count(collocation, this.statistics.getCollocationHistogram());
        }
    }

    private int processFieldsWithScheme(int total) {
        for (FieldWithScheme fieldWithScheme : fieldsWithScheme) {
            int count = this.processFieldWithScheme(this.marcRecord, fieldWithScheme);
            if (count <= 0) continue;
            total += count;
        }
        return total;
    }

    private int processFieldsWithoutSource(int total) {
        for (String tag : fieldsWithoutSource) {
            int count = this.processFieldWithoutSource(this.marcRecord, tag);
            if (count <= 0) continue;
            total += count;
        }
        return total;
    }

    private int processFieldsWithSubfield2(int total) {
        for (String tag : fieldsWithSubfield2) {
            int count = this.processFieldWithSubfield2(this.marcRecord, tag);
            if (count <= 0) continue;
            total += count;
        }
        return total;
    }

    private int processFieldsWithIndicator2AndSubfield2(int total) {
        for (String tag : fieldsWithIndicator2AndSubfield2) {
            int count = this.processFieldWithIndicator2AndSubfield2(this.marcRecord, tag);
            if (count <= 0) continue;
            total += count;
        }
        return total;
    }

    private int processFieldsWithIndicator1AndSubfield2(int total) {
        for (String tag : fieldsWithIndicator1AndSubfield2) {
            int count = this.processFieldWithIndicator1AndSubfield2(this.marcRecord, tag);
            if (count <= 0) continue;
            total += count;
        }
        return total;
    }

    private int processFieldWithScheme(MarcRecord marcRecord, FieldWithScheme fieldEntry) {
        int count = 0;
        String tag = fieldEntry.getTag();
        if (!marcRecord.hasDatafield(tag)) {
            return count;
        }
        List<DataField> fields = marcRecord.getDatafield(tag);
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (DataField field : fields) {
            String firstSubfield = null;
            String alt = null;
            for (MarcSubfield subfield : field.getSubfields()) {
                String code = subfield.getCode();
                if (!(code.equals("1") || code.equals("2") || code.equals("6") || code.equals("8"))) {
                    firstSubfield = "$" + code;
                    break;
                }
                if (alt != null) continue;
                alt = "$" + code;
            }
            if (firstSubfield != null) {
                String scheme = fieldEntry.getSchemaName();
                Schema currentSchema = new Schema(tag, firstSubfield, classificationSchemes.resolve(scheme), scheme);
                schemas.add(currentSchema);
                this.updateSchemaSubfieldStatistics(field, currentSchema);
                ++count;
                continue;
            }
            logger.severe(String.format("undetected subfield in record %s %s", marcRecord.getId(), field.toString()));
        }
        this.registerSchemas(schemas);
        return count;
    }

    private void registerSchemas(List<Schema> schemas) {
        this.addSchemasToStatistics(this.statistics.getInstances(), schemas);
        List<Schema> uniqSchemas = this.deduplicateSchema(schemas);
        this.addSchemasToStatistics(this.statistics.getRecords(), uniqSchemas);
        this.schemasInRecord.addAll(uniqSchemas);
    }

    private int processFieldWithIndicator1AndSubfield2(MarcRecord marcRecord, String tag) {
        int count = 0;
        if (!marcRecord.hasDatafield(tag)) {
            return count;
        }
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        List<DataField> fields = marcRecord.getDatafield(tag);
        for (DataField field : fields) {
            String scheme = field.resolveInd1();
            if (scheme.equals("No information provided")) continue;
            ++count;
            Schema currentSchema = null;
            if (this.isaReferenceToSubfield2(tag, scheme)) {
                currentSchema = this.extractSchemaFromSubfield2(tag, schemas, field);
            } else {
                try {
                    currentSchema = new Schema(tag, "ind1", classificationSchemes.resolve(scheme), scheme);
                }
                catch (IllegalArgumentException e) {
                    logger.severe(String.format("Invalid scheme in ind1: %s. %s", e.getLocalizedMessage(), field));
                    currentSchema = new Schema(tag, "ind1", field.getInd1(), scheme);
                }
                schemas.add(currentSchema);
            }
            this.updateSchemaSubfieldStatistics(field, currentSchema);
        }
        this.registerSchemas(schemas);
        return count;
    }

    private int processFieldWithIndicator2AndSubfield2(MarcRecord marcRecord, String tag) {
        int count = 0;
        if (!marcRecord.hasDatafield(tag)) {
            return count;
        }
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        List<DataField> fields = marcRecord.getDatafield(tag);
        for (DataField field : fields) {
            String scheme = field.resolveInd2();
            Schema currentSchema = null;
            if (this.isaReferenceToSubfield2(tag, scheme)) {
                currentSchema = this.extractSchemaFromSubfield2(tag, schemas, field);
                ++count;
            } else {
                try {
                    currentSchema = new Schema(tag, "ind2", classificationSchemes.resolve(scheme), scheme);
                }
                catch (IllegalArgumentException e) {
                    logger.warning(String.format("Invalid scheme in ind2: %s. %s", e.getLocalizedMessage(), field));
                    currentSchema = new Schema(tag, "ind2", field.getInd2(), scheme);
                }
                schemas.add(currentSchema);
                ++count;
            }
            this.updateSchemaSubfieldStatistics(field, currentSchema);
        }
        this.registerSchemas(schemas);
        return count;
    }

    private int processFieldWithSubfield2(MarcRecord marcRecord, String tag) {
        int count = 0;
        if (!marcRecord.hasDatafield(tag)) {
            return count;
        }
        List<DataField> fields = marcRecord.getDatafield(tag);
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (DataField field : fields) {
            Schema currentSchema = this.extractSchemaFromSubfield2(tag, schemas, field);
            this.updateSchemaSubfieldStatistics(field, currentSchema);
            ++count;
        }
        this.registerSchemas(schemas);
        return count;
    }

    private int processFieldWithoutSource(MarcRecord marcRecord, String tag) {
        int count = 0;
        if (!marcRecord.hasDatafield(tag)) {
            return count;
        }
        List<DataField> fields = marcRecord.getDatafield(tag);
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        for (DataField field : fields) {
            String abbreviavtion = field.getInd2().equals(" ") ? "#" : field.getInd2();
            Schema currentSchema = new Schema(tag, "ind2", "uncontrolled/" + abbreviavtion, field.resolveInd2());
            schemas.add(currentSchema);
            this.updateSchemaSubfieldStatistics(field, currentSchema);
            ++count;
        }
        this.registerSchemas(schemas);
        return count;
    }

    private Schema extractSchemaFromSubfield2(String tag, List<Schema> schemas, DataField field) {
        Schema currentSchema = null;
        List<MarcSubfield> altSchemes = field.getSubfield("2");
        if (altSchemes == null || altSchemes.isEmpty()) {
            currentSchema = new Schema(tag, "$2", "undetectable", "undetectable");
            schemas.add(currentSchema);
        } else {
            for (MarcSubfield altScheme : altSchemes) {
                currentSchema = new Schema(tag, "$2", altScheme.getValue(), altScheme.resolve());
                schemas.add(currentSchema);
            }
        }
        return currentSchema;
    }

    private void updateSchemaSubfieldStatistics(DataField field, Schema currentSchema) {
        if (currentSchema == null) {
            return;
        }
        List<String> subfields = this.orderSubfields(field.getSubfields());
        this.statistics.getSubfields().computeIfAbsent(currentSchema, s -> new HashMap());
        Map<List<String>, Integer> subfieldsStatistics = this.statistics.getSubfields().get(currentSchema);
        if (!subfieldsStatistics.containsKey(subfields)) {
            subfieldsStatistics.put(subfields, 1);
        } else {
            subfieldsStatistics.put(subfields, subfieldsStatistics.get(subfields) + 1);
        }
    }

    private List<String> orderSubfields(List<MarcSubfield> originalSubfields) {
        ArrayList<String> subfields = new ArrayList<String>();
        HashSet<String> multiFields = new HashSet<String>();
        for (MarcSubfield subfield : originalSubfields) {
            String code = subfield.getCode();
            if (!subfields.contains(code)) {
                subfields.add(code);
                continue;
            }
            multiFields.add(code);
        }
        if (!multiFields.isEmpty()) {
            for (String code : multiFields) {
                subfields.remove(code);
            }
            for (String code : multiFields) {
                subfields.add(code + "+");
            }
        }
        ArrayList<String> alphabetic = new ArrayList<String>();
        ArrayList<String> numeric = new ArrayList<String>();
        for (String subfield : subfields) {
            if (NUMERIC.matcher(subfield).matches()) {
                numeric.add(subfield);
                continue;
            }
            alphabetic.add(subfield);
        }
        if (!numeric.isEmpty()) {
            Collections.sort(alphabetic);
            Collections.sort(numeric);
            subfields = alphabetic;
            subfields.addAll(numeric);
        } else {
            Collections.sort(subfields);
        }
        return subfields;
    }

    private List<Schema> deduplicateSchema(List<Schema> schemas) {
        ArrayList<Schema> deduplicated = new ArrayList<Schema>();
        deduplicated.addAll(new HashSet<Schema>(schemas));
        return deduplicated;
    }

    private boolean isaReferenceToSubfield2(String field, String scheme) {
        return field.equals("055") && this.isAReferenceFrom055(scheme) || scheme.equals("Source specified in subfield $2");
    }

    private boolean isAReferenceFrom055(String scheme) {
        return scheme.equals("Other call number assigned by LAC") || scheme.equals("Other class number assigned by LAC") || scheme.equals("Other call number assigned by the contributing library") || scheme.equals("Other class number assigned by the contributing library");
    }

    private void addSchemasToStatistics(Map<Schema, Integer> fieldStatistics, List<Schema> schemes) {
        if (!schemes.isEmpty()) {
            for (Schema scheme : schemes) {
                Utils.count(scheme, fieldStatistics);
            }
        }
    }

    private void addSchemesToStatistics(Map<String[], Integer> fieldStatistics, List<String[]> schemes) {
        if (!schemes.isEmpty()) {
            for (String[] scheme : schemes) {
                if (!fieldStatistics.containsKey(scheme)) {
                    fieldStatistics.put(scheme, 0);
                    this.statistics.getFieldInRecords().computeIfAbsent(scheme, s -> 0);
                    this.statistics.getFieldInRecords().put(scheme, this.statistics.getFieldInRecords().get(scheme) + 1);
                }
                fieldStatistics.put(scheme, fieldStatistics.get(scheme) + 1);
            }
        }
    }

    private Map<String[], Integer> getFieldInstanceStatistics(String field) {
        this.statistics.getFieldInstances().computeIfAbsent(field, s -> new HashMap());
        return this.statistics.getFieldInstances().get(field);
    }

    public List<Schema> getSchemasInRecord() {
        return this.schemasInRecord;
    }

    public List<String> getCollocationInRecord() {
        return this.schemasInRecord.stream().map(Schema::getAbbreviation).sorted().distinct().collect(Collectors.toList());
    }
}

