/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import de.gwdg.metadataqa.marc.Validatable;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.MarcRecord;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.ValidatorResponse;
import de.gwdg.metadataqa.marc.definition.general.Linkage;
import de.gwdg.metadataqa.marc.definition.general.parser.ParserException;
import de.gwdg.metadataqa.marc.definition.general.parser.SubfieldContentParser;
import de.gwdg.metadataqa.marc.definition.general.validator.SubfieldValidator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.model.validation.ErrorsCollector;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import de.gwdg.metadataqa.marc.utils.keygenerator.DataFieldKeyGenerator;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class MarcSubfield
implements Validatable,
Serializable {
    private static final Logger logger = Logger.getLogger(MarcSubfield.class.getCanonicalName());
    private MarcRecord marcRecord;
    private DataField field;
    private SubfieldDefinition definition;
    private final String code;
    private final String value;
    private String codeForIndex = null;
    private ErrorsCollector errors = null;
    private Linkage linkage;
    private String referencePath;

    public MarcSubfield(SubfieldDefinition definition, String code, String value) {
        this.definition = definition;
        this.code = code;
        this.value = value;
    }

    public String getCode() {
        return this.code;
    }

    public String getValue() {
        return this.value;
    }

    public DataField getField() {
        return this.field;
    }

    public void setField(DataField field) {
        this.field = field;
    }

    public Linkage getLinkage() {
        return this.linkage;
    }

    public void setLinkage(Linkage linkage) {
        this.linkage = linkage;
    }

    public String getReferencePath() {
        return this.referencePath;
    }

    public void setReferencePath(String referencePath) {
        this.referencePath = referencePath;
    }

    public String getLabel() {
        String label = this.code;
        if (this.definition != null && this.definition.getLabel() != null) {
            label = this.definition.getLabel();
        }
        return label;
    }

    public String resolve() {
        if (this.definition == null) {
            return this.value;
        }
        return this.definition.resolve(this.value);
    }

    public SubfieldDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(SubfieldDefinition definition) {
        this.definition = definition;
    }

    public MarcRecord getMarcRecord() {
        return this.marcRecord;
    }

    public void setMarcRecord(MarcRecord marcRecord) {
        this.marcRecord = marcRecord;
    }

    public String getCodeForIndex() {
        if (this.codeForIndex == null) {
            this.codeForIndex = "_" + this.code;
            if (this.definition != null && this.definition.getCodeForIndex() != null) {
                this.codeForIndex = this.definition.getCodeForIndex();
            }
        }
        return this.codeForIndex;
    }

    public Map<String, String> parseContent() {
        if (this.definition.hasContentParser()) {
            try {
                return this.definition.getContentParser().parse(this.value);
            }
            catch (ParserException e) {
                String msg = String.format("Error in record: '%s' %s$%s: '%s'. Error message: '%s'", this.marcRecord.getId(), this.field.getTag(), this.definition.getCode(), this.value, e.getMessage());
                logger.severe(msg);
            }
        }
        return null;
    }

    public Map<String, List<String>> getKeyValuePairs(DataFieldKeyGenerator keyGenerator) {
        HashMap<String, List<String>> pairs = new HashMap<String, List<String>>();
        String prefix = keyGenerator.forSubfield(this);
        pairs.put(prefix, Collections.singletonList(this.resolve()));
        if (this.getDefinition() != null) {
            this.getKeyValuePairsForPositionalSubfields(pairs, prefix);
            this.getKeyValuePairsFromContentParser(keyGenerator, pairs);
        }
        return pairs;
    }

    private void getKeyValuePairsFromContentParser(DataFieldKeyGenerator keyGenerator, Map<String, List<String>> pairs) {
        Map<String, String> extra;
        if (this.getDefinition().hasContentParser() && (extra = this.parseContent()) != null) {
            for (Map.Entry<String, String> entry : extra.entrySet()) {
                pairs.put(keyGenerator.forSubfield(this, entry.getKey()), Collections.singletonList(entry.getValue()));
            }
        }
    }

    private void getKeyValuePairsForPositionalSubfields(Map<String, List<String>> pairs, String prefix) {
        if (this.getDefinition().hasPositions()) {
            Map<String, String> extra = this.getDefinition().resolvePositional(this.getValue());
            for (Map.Entry<String, String> entry : extra.entrySet()) {
                pairs.put(prefix + "_" + entry.getKey(), Collections.singletonList(entry.getValue()));
            }
        }
    }

    @Override
    public boolean validate(MarcVersion marcVersion) {
        boolean isValid = true;
        this.errors = new ErrorsCollector();
        if (marcVersion == null) {
            marcVersion = MarcVersion.MARC21;
        }
        if (this.definition == null) {
            this.addError(this.field.getDefinition().getTag(), ValidationErrorType.SUBFIELD_UNDEFINED, this.code);
            return false;
        }
        if (this.code == null) {
            this.addError(this.field.getDefinition().getTag(), ValidationErrorType.SUBFIELD_NULL_CODE, this.code);
            isValid = false;
        } else if (this.definition.isDisallowedIn(marcVersion)) {
            isValid = false;
        } else if (this.definition.hasValidator()) {
            if (!this.validateWithValidator()) {
                isValid = false;
            }
        } else if (this.definition.hasContentParser()) {
            if (!this.validateWithParser()) {
                isValid = false;
            }
        } else if (this.definition.getCodes() != null && this.definition.getCode(this.value) == null) {
            Object message = this.value;
            if (this.referencePath != null) {
                message = (String)message + String.format(" (the field is embedded in %s)", this.referencePath);
            }
            String path = this.referencePath == null ? this.definition.getPath() : this.referencePath + "->" + this.definition.getPath();
            this.addError(path, ValidationErrorType.SUBFIELD_INVALID_VALUE, (String)message);
            isValid = false;
        }
        return isValid;
    }

    private boolean validateWithValidator() {
        boolean isValid = true;
        SubfieldValidator validator = this.definition.getValidator();
        ValidatorResponse response = validator.isValid(this);
        if (!response.isValid()) {
            this.errors.addAll(response.getValidationErrors());
            isValid = false;
        }
        return isValid;
    }

    private boolean validateWithParser() {
        boolean isValid = true;
        SubfieldContentParser parser = this.definition.getContentParser();
        try {
            parser.parse(this.getValue());
        }
        catch (ParserException e) {
            this.addError(ValidationErrorType.SUBFIELD_UNPARSABLE_CONTENT, e.getMessage());
            isValid = false;
        }
        return isValid;
    }

    @Override
    public List<ValidationError> getValidationErrors() {
        return this.errors.getErrors();
    }

    private void addError(ValidationErrorType type, String message) {
        this.addError(this.definition.getPath(), type, message);
    }

    private void addError(String path, ValidationErrorType type, String message) {
        String url = this.definition.getParent().getDescriptionUrl();
        this.errors.add(this.marcRecord.getId(), path, type, message, url);
    }

    public String toString() {
        return "MarcSubfield{code='" + this.code + "', value='" + this.value + "'}";
    }
}

