/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc;

import de.gwdg.metadataqa.api.json.JsonBranch;
import de.gwdg.metadataqa.api.model.XmlFieldInstance;
import de.gwdg.metadataqa.api.model.pathcache.JsonPathCache;
import de.gwdg.metadataqa.api.schema.MarcJsonSchema;
import de.gwdg.metadataqa.api.schema.Schema;
import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.dao.Control001;
import de.gwdg.metadataqa.marc.dao.Control003;
import de.gwdg.metadataqa.marc.dao.Control005;
import de.gwdg.metadataqa.marc.dao.Control006;
import de.gwdg.metadataqa.marc.dao.Control007;
import de.gwdg.metadataqa.marc.dao.Control008;
import de.gwdg.metadataqa.marc.dao.DataField;
import de.gwdg.metadataqa.marc.dao.Leader;
import de.gwdg.metadataqa.marc.dao.MarcRecord;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.TagDefinitionLoader;
import de.gwdg.metadataqa.marc.definition.bibliographic.SchemaType;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.utils.MapToDatafield;
import de.gwdg.metadataqa.marc.utils.alephseq.AlephseqLine;
import de.gwdg.metadataqa.marc.utils.alephseq.MarcMakerLine;
import de.gwdg.metadataqa.marc.utils.alephseq.MarclineLine;
import de.gwdg.metadataqa.marc.utils.pica.PicaFieldDefinition;
import de.gwdg.metadataqa.marc.utils.pica.PicaLine;
import de.gwdg.metadataqa.marc.utils.pica.PicaSubfield;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.minidev.json.JSONArray;
import org.marc4j.marc.ControlField;
import org.marc4j.marc.Record;
import org.marc4j.marc.Subfield;
import org.marc4j.marc.VariableField;
import org.marc4j.marc.impl.ControlFieldImpl;
import org.marc4j.marc.impl.DataFieldImpl;
import org.marc4j.marc.impl.LeaderImpl;
import org.marc4j.marc.impl.RecordImpl;
import org.marc4j.marc.impl.SubfieldImpl;

public class MarcFactory {
    private static final Logger logger = Logger.getLogger(MarcFactory.class.getCanonicalName());
    private static final List<String> fixableControlFields = Arrays.asList("006", "007", "008");
    private static Schema schema = new MarcJsonSchema();

    private MarcFactory() {
        throw new IllegalStateException("This is a utility class, can not be instantiated");
    }

    public static MarcRecord create(JsonPathCache cache) {
        return MarcFactory.create(cache, MarcVersion.MARC21);
    }

    public static MarcRecord create(JsonPathCache cache, MarcVersion version) {
        MarcRecord marcRecord = new MarcRecord();
        block18: for (JsonBranch branch : schema.getPaths()) {
            if (branch.getParent() != null) continue;
            switch (branch.getLabel()) {
                case "leader": {
                    marcRecord.setLeader(new Leader(MarcFactory.extractFirst(cache, branch)));
                    continue block18;
                }
                case "001": {
                    marcRecord.setControl001(new Control001(MarcFactory.extractFirst(cache, branch)));
                    continue block18;
                }
                case "003": {
                    marcRecord.setControl003(new Control003(MarcFactory.extractFirst(cache, branch)));
                    continue block18;
                }
                case "005": {
                    marcRecord.setControl005(new Control005(MarcFactory.extractFirst(cache, branch), marcRecord));
                    continue block18;
                }
                case "006": {
                    marcRecord.setControl006(new Control006(MarcFactory.extractFirst(cache, branch), marcRecord));
                    continue block18;
                }
                case "007": {
                    marcRecord.setControl007(new Control007(MarcFactory.extractFirst(cache, branch), marcRecord));
                    continue block18;
                }
                case "008": {
                    marcRecord.setControl008(new Control008(MarcFactory.extractFirst(cache, branch), marcRecord));
                    continue block18;
                }
            }
            JSONArray fieldInstances = (JSONArray)cache.getFragment(branch.getJsonPath());
            for (int fieldInsanceNr = 0; fieldInsanceNr < fieldInstances.size(); ++fieldInsanceNr) {
                Map fieldInstance = (Map)fieldInstances.get(fieldInsanceNr);
                DataField field = MapToDatafield.parse(fieldInstance, version);
                if (field != null) {
                    marcRecord.addDataField(field);
                    field.setMarcRecord(marcRecord);
                    continue;
                }
                marcRecord.addUnhandledTags(branch.getLabel());
            }
        }
        return marcRecord;
    }

    public static MarcRecord createFromMarc4j(Record marc4jRecord) {
        return MarcFactory.createFromMarc4j(marc4jRecord, null, MarcVersion.MARC21);
    }

    public static MarcRecord createFromMarc4j(Record marc4jRecord, Leader.Type defaultType) {
        return MarcFactory.createFromMarc4j(marc4jRecord, defaultType, MarcVersion.MARC21);
    }

    public static MarcRecord createFromMarc4j(Record marc4jRecord, MarcVersion marcVersion) {
        return MarcFactory.createFromMarc4j(marc4jRecord, null, marcVersion);
    }

    public static MarcRecord createFromMarc4j(Record marc4jRecord, Leader.Type defaultType, MarcVersion marcVersion) {
        return MarcFactory.createFromMarc4j(marc4jRecord, defaultType, marcVersion, null);
    }

    public static MarcRecord createFromMarc4j(Record marc4jRecord, Leader.Type defaultType, MarcVersion marcVersion, String replecementInControlFields) {
        MarcRecord marcRecord = new MarcRecord();
        if (marc4jRecord.getLeader() != null) {
            String data = marc4jRecord.getLeader().marshal();
            if (replecementInControlFields != null) {
                data = data.replace(replecementInControlFields, " ");
            }
            marcRecord.setLeader(new Leader(data, defaultType));
            if (marcRecord.getType() == null) {
                throw new InvalidParameterException(String.format("Error in '%s': no type has been detected. Leader: '%s'.", marc4jRecord.getControlNumberField(), marcRecord.getLeader().getLeaderString()));
            }
        }
        MarcFactory.importMarc4jControlFields(marc4jRecord, marcRecord, replecementInControlFields);
        MarcFactory.importMarc4jDataFields(marc4jRecord, marcRecord, marcVersion);
        return marcRecord;
    }

    public static MarcRecord createPicaFromMarc4j(Record marc4jRecord, Map<String, PicaFieldDefinition> schemaDirectory) {
        MarcRecord marcRecord = new MarcRecord();
        marcRecord.setSchemaType(SchemaType.PICA);
        MarcFactory.importMarc4jControlFields(marc4jRecord, marcRecord, null);
        MarcFactory.importMarc4jDataFields(marc4jRecord, marcRecord, schemaDirectory);
        return marcRecord;
    }

    private static void importMarc4jControlFields(Record marc4jRecord, MarcRecord marcRecord, String replecementInControlFields) {
        for (ControlField controlField : marc4jRecord.getControlFields()) {
            String data = controlField.getData();
            if (replecementInControlFields != null && MarcFactory.isFixable(controlField.getTag())) {
                data = data.replace(replecementInControlFields, " ");
            }
            switch (controlField.getTag()) {
                case "001": {
                    marcRecord.setControl001(new Control001(data));
                    break;
                }
                case "003": {
                    marcRecord.setControl003(new Control003(data));
                    break;
                }
                case "005": {
                    marcRecord.setControl005(new Control005(data, marcRecord));
                    break;
                }
                case "006": {
                    marcRecord.setControl006(new Control006(data, marcRecord));
                    break;
                }
                case "007": {
                    marcRecord.setControl007(new Control007(data, marcRecord));
                    break;
                }
                case "008": {
                    marcRecord.setControl008(new Control008(data, marcRecord));
                    break;
                }
            }
        }
    }

    private static boolean isFixable(String tag) {
        return fixableControlFields.contains(tag);
    }

    private static void importMarc4jDataFields(Record marc4jRecord, MarcRecord marcRecord, MarcVersion marcVersion) {
        for (org.marc4j.marc.DataField dataField : marc4jRecord.getDataFields()) {
            DataFieldDefinition definition = MarcFactory.getDataFieldDefinition(dataField, marcVersion);
            if (definition == null) {
                marcRecord.addUnhandledTags(dataField.getTag());
            }
            DataField field = MarcFactory.extractDataField(dataField, definition, marcVersion);
            marcRecord.addDataField(field);
        }
    }

    private static void importMarc4jDataFields(Record marc4jRecord, MarcRecord marcRecord, Map<String, PicaFieldDefinition> schemaDirectory) {
        for (org.marc4j.marc.DataField dataField : marc4jRecord.getDataFields()) {
            PicaFieldDefinition definition;
            PicaFieldDefinition picaFieldDefinition = definition = schemaDirectory.containsKey(dataField.getTag()) ? schemaDirectory.get(dataField.getTag()) : null;
            if (definition == null) {
                marcRecord.addUnhandledTags(dataField.getTag());
            }
            DataField field = MarcFactory.extractPicaDataField(dataField, definition, MarcVersion.MARC21);
            marcRecord.addDataField(field);
        }
    }

    public static DataFieldDefinition getDataFieldDefinition(org.marc4j.marc.DataField dataField, MarcVersion marcVersion) {
        return MarcFactory.getDataFieldDefinition(dataField.getTag(), marcVersion);
    }

    public static DataFieldDefinition getDataFieldDefinition(String tag, MarcVersion marcVersion) {
        return TagDefinitionLoader.load(tag, marcVersion);
    }

    private static DataField extractDataField(org.marc4j.marc.DataField dataField, DataFieldDefinition definition, MarcVersion marcVersion) {
        DataField field = definition == null ? new DataField(dataField.getTag(), Character.toString(dataField.getIndicator1()), Character.toString(dataField.getIndicator2()), marcVersion) : new DataField(definition, Character.toString(dataField.getIndicator1()), Character.toString(dataField.getIndicator2()));
        for (Subfield subfield : dataField.getSubfields()) {
            String code = Character.toString(subfield.getCode());
            SubfieldDefinition subfieldDefinition = definition == null ? null : definition.getSubfield(code);
            MarcSubfield marcSubfield = null;
            marcSubfield = subfieldDefinition == null ? new MarcSubfield(null, code, subfield.getData()) : new MarcSubfield(subfieldDefinition, code, subfield.getData());
            marcSubfield.setField(field);
            field.getSubfields().add(marcSubfield);
        }
        field.indexSubfields();
        return field;
    }

    private static DataField extractPicaDataField(org.marc4j.marc.DataField dataField, PicaFieldDefinition definition, MarcVersion marcVersion) {
        DataField field = null;
        field = definition == null ? new DataField(dataField.getTag(), Character.toString(dataField.getIndicator1()), Character.toString(dataField.getIndicator2()), marcVersion) : new DataField(definition, Character.toString(dataField.getIndicator1()), Character.toString(dataField.getIndicator2()));
        for (Subfield subfield : dataField.getSubfields()) {
            String code = Character.toString(subfield.getCode());
            SubfieldDefinition subfieldDefinition = definition == null ? null : definition.getSubfield(code);
            MarcSubfield marcSubfield = null;
            marcSubfield = subfieldDefinition == null ? new MarcSubfield(null, code, subfield.getData()) : new MarcSubfield(subfieldDefinition, code, subfield.getData());
            marcSubfield.setField(field);
            field.getSubfields().add(marcSubfield);
        }
        field.indexSubfields();
        return field;
    }

    private static List<String> extractList(JsonPathCache cache, JsonBranch branch) {
        List instances = cache.get(branch.getJsonPath());
        ArrayList<String> values = new ArrayList<String>();
        if (instances != null) {
            for (XmlFieldInstance instance : instances) {
                values.add(instance.getValue());
            }
        }
        return values;
    }

    private static String extractFirst(JsonPathCache cache, JsonBranch branch) {
        List<String> list = MarcFactory.extractList(cache, branch);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static MarcRecord createFromFormattedText(String marcRecordAsText) {
        return MarcFactory.createFromFormattedText(Arrays.asList(marcRecordAsText.split("\n")));
    }

    public static MarcRecord createFromFormattedText(String marcRecordAsText, MarcVersion marcVersion) {
        return MarcFactory.createFromFormattedText(Arrays.asList(marcRecordAsText.split("\n")), marcVersion);
    }

    public static MarcRecord createFromFormattedText(List<String> lines) {
        return MarcFactory.createFromFormattedText(lines, MarcVersion.MARC21);
    }

    public static MarcRecord createFromFormattedText(List<String> lines, MarcVersion marcVersion) {
        if (marcVersion == null) {
            marcVersion = MarcVersion.MARC21;
        }
        MarcRecord marcRecord = new MarcRecord();
        for (String line : lines) {
            if (line.startsWith("LEADER ")) {
                marcRecord.setLeader(line.replace("LEADER ", ""), marcVersion);
                continue;
            }
            String tag = line.substring(0, 3);
            String content = line.substring(4);
            marcRecord.setField(tag, content, marcVersion);
        }
        return marcRecord;
    }

    public static MarcRecord createFromAlephseq(List<AlephseqLine> lines, MarcVersion marcVersion) {
        if (marcVersion == null) {
            marcVersion = MarcVersion.MARC21;
        }
        MarcRecord marcRecord = new MarcRecord();
        for (AlephseqLine line : lines) {
            if (line.isLeader()) {
                marcRecord.setLeader(line.getContent());
                continue;
            }
            if (!line.isNumericTag()) continue;
            marcRecord.setField(line.getTag(), line.getInd1(), line.getInd2(), line.getContent(), marcVersion);
        }
        return marcRecord;
    }

    public static Record createRecordFromAlephseq(List<AlephseqLine> lines) {
        RecordImpl marc4jRecord = new RecordImpl();
        for (AlephseqLine line : lines) {
            if (line.isLeader()) {
                marc4jRecord.setLeader((org.marc4j.marc.Leader)new LeaderImpl(line.getContent()));
                continue;
            }
            if (!line.isNumericTag()) continue;
            if (line.isControlField()) {
                marc4jRecord.addVariableField((VariableField)new ControlFieldImpl(line.getTag(), line.getContent()));
                continue;
            }
            DataFieldImpl df = new DataFieldImpl(line.getTag(), line.getInd1().charAt(0), line.getInd2().charAt(0));
            for (String[] pair : line.parseSubfields()) {
                if (pair.length == 2 && pair[0] != null && pair[1] != null) {
                    df.addSubfield((Subfield)new SubfieldImpl(pair[0].charAt(0), pair[1]));
                    continue;
                }
                logger.warning(String.format("parse error in record #%s) tag %s: '%s'", line.getRecordID(), line.getTag(), line.getRawContent()));
            }
            marc4jRecord.addVariableField((VariableField)df);
        }
        return marc4jRecord;
    }

    public static Record createRecordFromMarcline(List<MarclineLine> lines) {
        RecordImpl marc4jRecord = new RecordImpl();
        for (MarclineLine line : lines) {
            if (line.isLeader()) {
                try {
                    marc4jRecord.setLeader((org.marc4j.marc.Leader)new LeaderImpl(line.getContent()));
                }
                catch (StringIndexOutOfBoundsException e) {
                    logger.severe("Error at creating leader: " + e.getMessage());
                }
                continue;
            }
            if (!line.isNumericTag()) continue;
            if (line.isControlField()) {
                marc4jRecord.addVariableField((VariableField)new ControlFieldImpl(line.getTag(), line.getContent()));
                continue;
            }
            DataFieldImpl df = new DataFieldImpl(line.getTag(), line.getInd1().charAt(0), line.getInd2().charAt(0));
            for (String[] pair : line.parseSubfields()) {
                if (pair.length == 2 && pair[0] != null && pair[1] != null) {
                    df.addSubfield((Subfield)new SubfieldImpl(pair[0].charAt(0), pair[1]));
                    continue;
                }
                logger.warning(String.format("parse error in record #%s) tag %s: '%s'", line.getRecordID(), line.getTag(), line.getRawContent()));
            }
            marc4jRecord.addVariableField((VariableField)df);
        }
        return marc4jRecord;
    }

    public static Record createRecordFromMarcMaker(List<MarcMakerLine> lines) {
        RecordImpl marc4jRecord = new RecordImpl();
        for (MarcMakerLine line : lines) {
            if (line.isLeader()) {
                try {
                    marc4jRecord.setLeader((org.marc4j.marc.Leader)new LeaderImpl(line.getContent()));
                }
                catch (StringIndexOutOfBoundsException e) {
                    logger.severe("Error at creating leader: " + e.getMessage());
                }
                continue;
            }
            if (!line.isNumericTag()) continue;
            if (line.isControlField()) {
                marc4jRecord.addVariableField((VariableField)new ControlFieldImpl(line.getTag(), line.getContent()));
                continue;
            }
            DataFieldImpl df = new DataFieldImpl(line.getTag(), line.getInd1().charAt(0), line.getInd2().charAt(0));
            for (String[] pair : line.parseSubfields()) {
                if (pair.length == 2 && pair[0] != null && pair[1] != null) {
                    df.addSubfield((Subfield)new SubfieldImpl(pair[0].charAt(0), pair[1]));
                    continue;
                }
                logger.warning(String.format("parse error in record #%s) tag %s: '%s'", line.getRecordID(), line.getTag(), line.getRawContent()));
            }
            marc4jRecord.addVariableField((VariableField)df);
        }
        return marc4jRecord;
    }

    public static Record createRecordFromPica(List<PicaLine> lines) {
        RecordImpl marc4jRecord = new RecordImpl();
        String id = null;
        for (PicaLine line : lines) {
            DataFieldImpl df = new DataFieldImpl(line.getTag(), ' ', ' ');
            for (PicaSubfield picaSubfield : line.getSubfields()) {
                df.addSubfield((Subfield)new SubfieldImpl(picaSubfield.getCode().charAt(0), picaSubfield.getValue()));
                if (!line.getTag().equals("003@") || !picaSubfield.getCode().equals("0")) continue;
                id = picaSubfield.getValue();
            }
            marc4jRecord.addVariableField((VariableField)df);
        }
        if (id != null) {
            marc4jRecord.addVariableField((VariableField)new ControlFieldImpl("001", id));
        }
        return marc4jRecord;
    }
}

