/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica;

import de.gwdg.metadataqa.marc.utils.pica.PicaplusTag;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class PicaTagDefinition {
    private static final Logger logger = Logger.getLogger(PicaTagDefinition.class.getCanonicalName());
    private static final Pattern rangePattern = Pattern.compile("^(\\d+)-(\\d+)$");
    private final String pica3;
    private Boolean repeatable;
    private Boolean hasSheet;
    private final String description;
    private PicaplusTag tag;

    public PicaTagDefinition(String pica3, String picaplus, boolean repeatable, boolean sheet, String description) {
        this.pica3 = pica3;
        this.repeatable = repeatable;
        this.hasSheet = sheet;
        this.description = description;
        this.tag = new PicaplusTag(picaplus);
    }

    public PicaTagDefinition(String[] input) {
        this.pica3 = input[0];
        this.tag = new PicaplusTag(input[1]);
        this.description = input[4];
        this.parseRepeatable(input[2]);
        this.parseSheet(input[3]);
    }

    public PicaplusTag getTag() {
        return this.tag;
    }

    private void parseSheet(String input) {
        switch (input) {
            case "": 
            case "-": {
                this.hasSheet = false;
                break;
            }
            case "+": {
                this.hasSheet = true;
                break;
            }
            default: {
                logger.severe(String.format("unhandled 'hasSheet' value: %s (%s)", input, this.tag.getRaw()));
            }
        }
    }

    private void parseRepeatable(String input) {
        switch (input) {
            case "": {
                this.repeatable = false;
                break;
            }
            case "*": {
                this.repeatable = true;
                break;
            }
            default: {
                logger.severe("unhandled 'repeatable' value: " + input);
            }
        }
    }

    public String getPica3() {
        return this.pica3;
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public boolean isHasSheet() {
        return this.hasSheet;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "PicaTagDefinition{pica3='" + this.pica3 + '\'' + ", picaplus='" + this.tag.getRaw() + '\'' + ", repeatable=" + this.repeatable + ", hasSheet=" + this.hasSheet + ", description='" + this.description + '\'' + '}';
    }
}

