/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.pica;

import de.gwdg.metadataqa.marc.utils.pica.PicaSubfield;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class PicaLine {
    private static final Logger logger = Logger.getLogger(PicaLine.class.getCanonicalName());
    private static final Pattern LINE = Pattern.compile("^([0-2][0-9][0-9][A-Z@])(\\/([0-9][0-9]+))? (.*)$");
    private static final String LDR = "LDR";
    private static final Pattern numericTag = Pattern.compile("^\\d\\d\\d$");
    private static final Pattern controlField = Pattern.compile("^00\\d$");
    public static final String SEPARATOR = "\u0192";
    private int lineNumber = 0;
    private String recordID;
    private String tag;
    private String occurrence;
    private String content;
    private List<PicaSubfield> subfields;
    private boolean valid = true;

    public PicaLine() {
    }

    public PicaLine(String raw) {
        this.parse(raw);
    }

    public PicaLine(String raw, int lineNumber) {
        this.lineNumber = lineNumber;
        this.parse(raw);
    }

    public boolean isLeader() {
        return this.tag.equals(LDR);
    }

    public boolean isNumericTag() {
        return numericTag.matcher(this.tag).matches();
    }

    public boolean isControlField() {
        return controlField.matcher(this.tag).matches();
    }

    public boolean isValidTag() {
        return this.isValid() && (this.isLeader() || this.isNumericTag());
    }

    public String getRecordID() {
        return this.recordID;
    }

    public String getTag() {
        return this.tag;
    }

    public String getOccurrence() {
        return this.occurrence;
    }

    public List<PicaSubfield> getSubfields() {
        return this.subfields;
    }

    public String getQualifiedTag() {
        if (this.occurrence != null) {
            return this.tag + "/" + this.occurrence;
        }
        return this.tag;
    }

    public String formatSubfields() {
        if (this.subfields == null) {
            logger.severe("null subfields: " + this.content);
            return "";
        }
        ArrayList<String> formattedSubfields = new ArrayList<String>();
        for (PicaSubfield subfield : this.subfields) {
            formattedSubfields.add(subfield.format());
        }
        return StringUtils.join(formattedSubfields, (String)", ");
    }

    public String getContent() {
        if (this.isLeader() || this.isControlField()) {
            return this.content.replace("^", " ");
        }
        return this.content.replace("$$", "$");
    }

    public String getRawContent() {
        return this.content;
    }

    private void parse(String raw) {
        Matcher matcher = LINE.matcher(raw);
        if (matcher.matches()) {
            this.tag = matcher.group(1);
            this.occurrence = matcher.group(3);
            this.content = matcher.group(4);
            this.parseSubfields();
        } else {
            logger.warning("Unable to parse line: " + raw);
        }
    }

    private void parseSubfields() {
        String[] parts;
        this.subfields = new ArrayList<PicaSubfield>();
        for (String part : parts = this.content.split(SEPARATOR)) {
            if (!StringUtils.isNotBlank((String)part)) continue;
            this.subfields.add(new PicaSubfield(part.substring(0, 1), part.substring(1)));
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        return "AlephseqLine{recordID='" + this.recordID + '\'' + ", tag='" + this.tag + '\'' + ", occurrence='" + this.occurrence + '\'' + ", subfields=" + this.subfields + '}';
    }
}

