/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.marcspec;

import de.gwdg.metadataqa.marc.utils.marcspec.Field;
import de.gwdg.metadataqa.marc.utils.marcspec.MARCspecParser;
import de.gwdg.metadataqa.marc.utils.marcspec.Position;
import de.gwdg.metadataqa.marc.utils.marcspec.Subfield;
import de.gwdg.metadataqa.marc.utils.marcspec.exception.InvalidMARCspecException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class MARCspec {
    public static final Pattern hasSpacePattern = Pattern.compile("\\s");
    private Field field;
    private List<Subfield> subfields;

    public MARCspec(Field field) {
        this();
        this.field = field;
    }

    public MARCspec() {
        this.subfields = new ArrayList<Subfield>();
    }

    public MARCspec(String spec) {
        MARCspecParser parser = new MARCspecParser();
        MARCspec o = parser.parse(spec);
        this.field = o.getField();
        this.subfields = o.getSubfields();
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public List<Subfield> getSubfields() {
        return this.subfields;
    }

    public void setSubfields(List<Subfield> subfields) {
        this.subfields = subfields;
    }

    public static Position[] validatePos(String positionInput) {
        int posLength = positionInput.length();
        if (1 > posLength) {
            throw new InvalidMARCspecException("PositionOrRange. Assuming index or character position or range. Minimum one character is required. None given.", positionInput);
        }
        Pattern positionPattern = Pattern.compile("[^0-9\\-#]");
        if (positionPattern.matcher(positionInput).find()) {
            throw new InvalidMARCspecException("PositionOrRange. Assuming index or character position or range. Only digits, the character # and one \"-\" is allowed.", positionInput);
        }
        if (positionInput.endsWith("-")) {
            throw new InvalidMARCspecException("PositionOrRange. Assuming index or character range. At least two digits or the character # must be present.", positionInput);
        }
        if (positionInput.startsWith("-")) {
            throw new InvalidMARCspecException("PositionOrRange. Assuming index or character position or range. First character must not be \"-\".", positionInput);
        }
        String[] positions = positionInput.split("-");
        if (positions.length > 2) {
            throw new InvalidMARCspecException("PositionOrRange. Assuming index or character position or range. Only one \"-\" character allowed.", positionInput);
        }
        if (2 < positions.length) {
            throw new InvalidMARCspecException("PositionOrRange. Assuming index or character position or range. Only digits and one \"-\" is allowed.", positionInput);
        }
        if (1 == positions.length) {
            positions[1] = null;
        }
        Position[] indexPositions = new Position[positions.length];
        for (int i = 0; i < positions.length; ++i) {
            indexPositions[i] = new Position(positions[i]);
        }
        return indexPositions;
    }

    public void addSubfield(Subfield subfield) {
        this.subfields.add(subfield);
    }

    public String toString() {
        return "MARCspec{field=" + this.field + ", subfields=" + this.subfields + '}';
    }
}

