/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils.keygenerator;

import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.model.SolrFieldType;

public class DataFieldKeyGenerator {
    private DataFieldDefinition definition;
    private SolrFieldType type;
    private String tag;
    private String indexTag;

    public DataFieldKeyGenerator(DataFieldDefinition definition, SolrFieldType type) {
        this.definition = definition;
        this.type = type;
        this.tag = definition.getTag();
        this.indexTag = definition.getIndexTag();
    }

    public DataFieldKeyGenerator(DataFieldDefinition definition, SolrFieldType type, String tag) {
        this.definition = definition;
        this.type = type;
        if (definition != null) {
            this.tag = definition.getTag();
            this.indexTag = definition.getIndexTag();
        } else {
            this.tag = tag;
            this.indexTag = tag;
        }
    }

    public String forInd1() {
        String key = "";
        switch (this.type) {
            case HUMAN: {
                key = String.format("%s_%s", this.indexTag, this.definition.getInd1().getIndexTag());
                break;
            }
            case MIXED: {
                if (this.definition == null) {
                    key = String.format("%sind1", this.tag);
                    break;
                }
                key = String.format("%sind1_%s_%s", this.tag, this.indexTag, this.definition.getInd1().getIndexTag());
                break;
            }
            default: {
                key = String.format("%sind1", this.tag);
            }
        }
        return key;
    }

    public String forInd2() {
        String key = "";
        switch (this.type) {
            case HUMAN: {
                key = String.format("%s_%s", this.indexTag, this.definition.getInd2().getIndexTag());
                break;
            }
            case MIXED: {
                if (this.definition == null) {
                    key = String.format("%sind2", this.tag);
                    break;
                }
                key = String.format("%sind2_%s_%s", this.tag, this.indexTag, this.definition.getInd2().getIndexTag());
                break;
            }
            default: {
                key = String.format("%sind2", this.tag);
            }
        }
        return key;
    }

    public String forSubfield(MarcSubfield subfield) {
        return this.forSubfield(subfield.getCode(), subfield.getCodeForIndex());
    }

    public String forSubfield(SubfieldDefinition subfield) {
        return this.forSubfield(subfield.getCode(), subfield.getCodeForIndex());
    }

    private String forSubfield(String code, String codeForIndex) {
        String key = "";
        switch (this.type) {
            case HUMAN: {
                key = String.format("%s%s", this.indexTag, codeForIndex);
                break;
            }
            case MIXED: {
                if (!this.tag.equals(this.indexTag) && !codeForIndex.equals("_" + code)) {
                    key = String.format("%s%s_%s%s", this.tag, code, this.indexTag, codeForIndex);
                    break;
                }
                if (!this.tag.equals(this.indexTag) && codeForIndex.equals("_" + code)) {
                    key = String.format("%s%s_%s", this.tag, code, this.indexTag);
                    break;
                }
                key = String.format("%s%s", this.tag, code);
                break;
            }
            default: {
                key = String.format("%s%s", this.tag, code);
            }
        }
        return key;
    }

    public String getIndexTag() {
        return this.indexTag;
    }

    public String forSubfield(MarcSubfield subfield, String extra) {
        return String.format("%s_%s", this.forSubfield(subfield), extra);
    }
}

