/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils;

import de.gwdg.metadataqa.marc.utils.LineSeparatedMarcReader;
import de.gwdg.metadataqa.marc.utils.alephseq.AlephseqMarcReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.marc4j.MarcReader;
import org.marc4j.MarcStreamReader;
import org.marc4j.MarcXmlReader;
import org.marc4j.marc.Record;

public class ReadMarc {
    public static List<Record> read(String fileName) throws Exception {
        FileInputStream in = new FileInputStream(fileName);
        MarcStreamReader reader = new MarcStreamReader((InputStream)in);
        ArrayList<Record> records = new ArrayList<Record>();
        while (reader.hasNext()) {
            Record marc4jRecord = reader.next();
            records.add(marc4jRecord);
        }
        return records;
    }

    public static MarcReader getStreamReader(String fileName) throws Exception {
        FileInputStream in = new FileInputStream(fileName);
        MarcStreamReader reader = new MarcStreamReader((InputStream)in);
        return reader;
    }

    public static MarcReader getXmlReader(String fileName) throws Exception {
        FileInputStream in = new FileInputStream(fileName);
        MarcXmlReader reader = new MarcXmlReader((InputStream)in);
        return reader;
    }

    public static MarcReader getLineSeparatedMarcReader(String fileName) throws Exception {
        LineSeparatedMarcReader reader = new LineSeparatedMarcReader(fileName);
        return reader;
    }

    public static MarcReader getMarcStringReader(String content) throws Exception {
        ByteArrayInputStream is = new ByteArrayInputStream(content.getBytes());
        MarcStreamReader reader = new MarcStreamReader((InputStream)is);
        return reader;
    }

    public static MarcReader getAlephseqMarcReader(String fileName) throws Exception {
        AlephseqMarcReader reader = new AlephseqMarcReader(fileName);
        return reader;
    }

    public static MarcReader getReader(String fileName, boolean isMarcxml) throws Exception {
        return ReadMarc.getReader(fileName, isMarcxml, false);
    }

    public static MarcReader getReader(String fileName, boolean isMarcxml, boolean isLineSeaparated) throws Exception {
        MarcReader reader = null;
        reader = isLineSeaparated ? ReadMarc.getLineSeparatedMarcReader(fileName) : (isMarcxml ? ReadMarc.getXmlReader(fileName) : ReadMarc.getStreamReader(fileName));
        return reader;
    }
}

