/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import org.marc4j.MarcReader;
import org.marc4j.MarcStreamReader;
import org.marc4j.marc.Record;

public class LineSeparatedMarcReader
implements MarcReader {
    private BufferedReader bufferedReader = null;
    private String line = null;
    private boolean nextIsConsumed = false;
    private int lineNumber = 0;

    public LineSeparatedMarcReader(String lineSeparatedMarc) {
        try {
            this.bufferedReader = new BufferedReader(new FileReader(lineSeparatedMarc));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public boolean hasNext() {
        if (this.lineNumber == 0 || this.nextIsConsumed) {
            try {
                this.line = this.bufferedReader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++this.lineNumber;
            this.nextIsConsumed = false;
        }
        return this.line != null;
    }

    public Record next() {
        ByteArrayInputStream is = new ByteArrayInputStream(this.line.getBytes());
        MarcStreamReader reader = new MarcStreamReader((InputStream)is);
        Record marc4jRecord = null;
        if (reader.hasNext()) {
            marc4jRecord = reader.next();
        }
        this.nextIsConsumed = true;
        return marc4jRecord;
    }
}

