/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils;

import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.structure.ControlFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.ControlfieldPositionDefinition;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.MarcDefinition;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import de.gwdg.metadataqa.marc.utils.AppendableHashMap;
import de.gwdg.metadataqa.marc.utils.Counter;
import de.gwdg.metadataqa.marc.utils.FunctionValue;
import de.gwdg.metadataqa.marc.utils.MarcTagLister;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class FrbrFunctionLister {
    private Counter<FRBRFunction> baselineCounter = new Counter();
    private int elementsWithoutFunctions;
    private MarcVersion marcVersion;
    private Map<FRBRFunction, FunctionValue> collector;
    private Map<FRBRFunction, Counter<FunctionValue>> histogram;
    private Map<String, List<FRBRFunction>> functionByMarcPath;
    private AppendableHashMap<FRBRFunction, String> marcPathByfunction;

    public FrbrFunctionLister(MarcVersion marcVersion) {
        this.marcVersion = marcVersion;
        this.prepareBaseline();
        this.prepareCollector();
        this.prepareHistogram();
        System.err.println("Covered elements: " + this.functionByMarcPath.size());
        System.err.println("Uncovered elements: " + this.elementsWithoutFunctions);
    }

    public Map<FRBRFunction, Counter<FunctionValue>> getHistogram() {
        return this.histogram;
    }

    public void prepareBaseline() {
        this.elementsWithoutFunctions = 0;
        this.functionByMarcPath = new TreeMap<String, List<FRBRFunction>>();
        this.marcPathByfunction = new AppendableHashMap();
        for (ControlfieldPositionDefinition controlfieldPositionDefinition : MarcDefinition.leaderPositions) {
            this.registerFunctions(controlfieldPositionDefinition.getFrbrFunctions(), controlfieldPositionDefinition.getPath(false));
        }
        for (DataFieldDefinition dataFieldDefinition : MarcDefinition.simpleControlFields) {
            this.registerFunctions(dataFieldDefinition.getFrbrFunctions(), dataFieldDefinition.getTag());
        }
        for (ControlFieldDefinition controlFieldDefinition : MarcDefinition.complexControlFields) {
            for (List<ControlfieldPositionDefinition> positions : controlFieldDefinition.getControlfieldPositions().values()) {
                for (ControlfieldPositionDefinition controlfieldPositionDefinition : positions) {
                    this.registerFunctions(controlfieldPositionDefinition.getFrbrFunctions(), controlfieldPositionDefinition.getId().replace("tag", ""));
                }
            }
        }
        for (Class clazz : MarcTagLister.listTags()) {
            MarcVersion currentVersion = Utils.getVersion(clazz);
            try {
                Method getInstance = clazz.getMethod("getInstance", new Class[0]);
                DataFieldDefinition fieldTag = (DataFieldDefinition)getInstance.invoke((Object)clazz, new Object[0]);
                if (currentVersion != MarcVersion.MARC21 && currentVersion != this.marcVersion) continue;
                ++this.elementsWithoutFunctions;
                for (Indicator indicator : fieldTag.getIndicators()) {
                    this.registerFunctions(indicator.getFrbrFunctions(), indicator.getPath());
                }
                if (fieldTag.getSubfields() == null) continue;
                for (SubfieldDefinition subfield : fieldTag.getSubfields()) {
                    this.registerFunctions(subfield.getFrbrFunctions(), subfield.getPath());
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                reflectiveOperationException.printStackTrace();
            }
        }
    }

    private void registerFunctions(List<FRBRFunction> functions, String marcPath) {
        if (functions != null && !functions.isEmpty()) {
            this.functionByMarcPath.put(marcPath, functions);
            for (FRBRFunction function : functions) {
                this.marcPathByfunction.append(function, marcPath);
                this.baselineCounter.count(function);
            }
        } else {
            ++this.elementsWithoutFunctions;
        }
    }

    public static void countFunctions(List<FRBRFunction> functions, Map<FRBRFunction, FunctionValue> map) {
        if (functions != null && !functions.isEmpty()) {
            for (FRBRFunction function : functions) {
                if (!map.containsKey((Object)function)) {
                    map.put(function, new FunctionValue());
                }
                map.get((Object)function).count();
            }
        }
    }

    private void prepareCollector() {
        this.collector = new TreeMap<FRBRFunction, FunctionValue>();
        for (FRBRFunction key : this.baselineCounter.keys()) {
            this.collector.put(key, new FunctionValue());
        }
    }

    private void prepareHistogram() {
        this.histogram = new TreeMap<FRBRFunction, Counter<FunctionValue>>();
        for (FRBRFunction key : this.baselineCounter.keys()) {
            this.histogram.put(key, new Counter());
        }
    }

    public void calculatePercent(Map<FRBRFunction, FunctionValue> other) {
        for (FRBRFunction key : this.baselineCounter.keys()) {
            if (!other.containsKey((Object)key)) continue;
            other.get((Object)key).calculatePercent(this.baselineCounter.get(key));
        }
    }

    public void add(Map<FRBRFunction, FunctionValue> other) {
        for (FRBRFunction key : other.keySet()) {
            if (!this.collector.containsKey((Object)key)) {
                this.collector.put(key, new FunctionValue());
            }
            this.collector.get((Object)key).add(other.get((Object)key));
        }
    }

    public Map<FRBRFunction, List<Double>> percentOf(int total) {
        TreeMap<FRBRFunction, List<Double>> result = new TreeMap<FRBRFunction, List<Double>>();
        for (FRBRFunction key : this.collector.keySet()) {
            double avgCount = (double)this.collector.get((Object)key).getCount() * 1.0 / (double)total;
            double avgPerc = this.collector.get((Object)key).getPercent() * 1.0 / (double)total;
            result.put(key, Arrays.asList(avgCount, avgPerc));
        }
        return result;
    }

    public void addToHistogram(Map<FRBRFunction, FunctionValue> other) {
        for (Map.Entry<FRBRFunction, FunctionValue> entry : other.entrySet()) {
            FRBRFunction function = entry.getKey();
            FunctionValue value = entry.getValue();
            if (!this.histogram.containsKey((Object)function)) {
                this.histogram.put(function, new Counter());
            }
            this.histogram.get((Object)function).count(value);
        }
    }

    public Map<FRBRFunction, Integer> getBaseline() {
        return this.baselineCounter.getMap();
    }

    public Map<FRBRFunction, List<String>> getMarcPathByfunction() {
        return this.marcPathByfunction.getMap();
    }
}

