/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.utils;

import de.gwdg.metadataqa.marc.Code;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;

public class CodeFileReader {
    public static List<Code> fileToCodeList(String fileName) {
        ArrayList<Code> codes = new ArrayList<Code>();
        try {
            LineIterator it = CodeFileReader.getLineIterator(fileName);
            while (it.hasNext()) {
                String line = it.nextLine();
                if (line.equals("") || line.startsWith("#")) continue;
                String[] parts = line.split(";", 2);
                codes.add(new Code(parts[0], parts[1]));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return codes;
    }

    public static Map<String, String> fileToDict(String fileName) throws IOException, URISyntaxException {
        LineIterator it = CodeFileReader.getLineIterator(fileName);
        HashMap<String, String> dict = new HashMap<String, String>();
        while (it.hasNext()) {
            String line = it.nextLine();
            if (line.equals("") || line.startsWith("#")) continue;
            String[] parts = line.split(";", 2);
            dict.put(parts[0], parts[1]);
        }
        return dict;
    }

    private static LineIterator getLineIterator(String fileName) throws IOException {
        ClassLoader classLoader = CodeFileReader.class.getClassLoader();
        return IOUtils.lineIterator((InputStream)classLoader.getResourceAsStream(fileName), (Charset)Charset.defaultCharset());
    }
}

