/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags84x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.codelist.FormatSourceCodes;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;

public class Tag886
extends DataFieldDefinition {
    private static Tag886 uniqueInstance;

    private Tag886() {
        this.initialize();
        this.postCreation();
    }

    public static Tag886 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag886();
        }
        return uniqueInstance;
    }

    private void initialize() {
        int c;
        this.tag = "886";
        this.label = "Foreign MARC Information Field";
        this.mqTag = "ForeignMARCInformationField";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd886.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Type of field").setCodes("0", "Leader", "1", "Variable control fields (002-009)", "2", "Variable data fields (010-999)").setMqTag("typeOfField").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Tag of the foreign MARC field", "NR", "b", "Content of the foreign MARC field", "NR", "2", "Source of data", "NR");
        this.getSubfield("2").setCodeList(FormatSourceCodes.getInstance());
        this.getSubfield("a").setMqTag("tag").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("content").setCompilanceLevels("M");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("M");
        for (c = 97; c <= 122; c = (char)(c + '\u0001')) {
            this.subfields.add(new SubfieldDefinition(String.valueOf((char)c), "Foreign MARC subfield", "R").setParent(this).setCompilanceLevels("A"));
        }
        for (c = 0; c <= 9; ++c) {
            this.subfields.add(new SubfieldDefinition(String.valueOf(c), "Foreign MARC subfield", "R").setParent(this).setCompilanceLevels("A"));
        }
        this.setHistoricalSubfields("c", "Content of the foreign MARC control fields 002-009 [OBSOLETE, 1997] [CAN/MARC only]", "d", "Content designators and data elements of the foreign MARC variable fields 010-999 [OBSOLETE, 1997] [CAN/MARC only]");
    }
}

