/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags84x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag882
extends DataFieldDefinition {
    private static Tag882 uniqueInstance;

    private Tag882() {
        this.initialize();
        this.postCreation();
    }

    public static Tag882 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag882();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "882";
        this.label = "Replacement Record Information";
        this.cardinality = Cardinality.Nonrepeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd882.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Replacement title", "R", "i", "Explanatory text", "R", "w", "Replacement bibliographic record control number", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("w").setCodeList(OrganizationCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("replacementTitle").setCompilanceLevels("M");
        this.getSubfield("i").setMqTag("explanatoryText").setCompilanceLevels("O");
        this.getSubfield("w").setMqTag("controlNumber").setCompilanceLevels("A");
        this.getSubfield("6").setMqTag("linkage").setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setCompilanceLevels("O");
    }
}

