/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags84x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag850
extends DataFieldDefinition {
    private static Tag850 uniqueInstance;

    private Tag850() {
        this.initialize();
        this.postCreation();
    }

    public static Tag850 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag850();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "850";
        this.label = "Holding Institution";
        this.bibframeTag = "HeldBy";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd850.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Holding institution", "R", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setCodeList(OrganizationCodes.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("M");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.setHistoricalSubfields("b", "Holdings (MU, VM, SE) [OBSOLETE, 1990]", "d", "Inclusive dates (MU, VM, SE) [OBSOLETE, 1990]", "e", "Retention statement (CF, MU, VM, SE) [OBSOLETE, 1990]");
    }
}

