/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags6xx;

import de.gwdg.metadataqa.marc.Code;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.codelist.RelatorCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.SubjectHeadingAndTermSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag651
extends DataFieldDefinition {
    private static Tag651 uniqueInstance;

    private Tag651() {
        this.initialize();
        this.postCreation();
    }

    public static Tag651 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag651();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "651";
        this.label = "Subject Added Entry - Geographic Name";
        this.bibframeTag = "Geographic";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd651.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator("Thesaurus").setCodes("0", "Library of Congress Subject Headings", "1", "LC subject headings for children's literature", "2", "Medical Subject Headings", "3", "National Agricultural Library subject authority file", "4", "Source not specified", "5", "Canadian Subject Headings", "6", "R\u00e9pertoire de vedettes-mati\u00e8re", "7", "Source specified in subfield $2").putVersionSpecificCodes(MarcVersion.NKCR, Arrays.asList(new Code("9", "English variant of term"))).setMqTag("thesaurus").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.setSubfieldsWithCardinality("a", "Geographic name", "NR", "e", "Relator term", "R", "g", "Miscellaneous information", "R", "4", "Relationship", "R", "v", "Form subdivision", "R", "x", "General subdivision", "R", "y", "Chronological subdivision", "R", "z", "Geographic subdivision", "R", "0", "Authority record control number or standard number", "R", "2", "Source of heading or term", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("4").setCodeList(RelatorCodes.getInstance());
        this.getSubfield("2").setCodeList(SubjectHeadingAndTermSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("e").setMqTag("relator").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("g").setMqTag("miscellaneous");
        this.getSubfield("v").setBibframeTag("formGenre").setMqTag("formSubdivision").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("x").setBibframeTag("topic").setMqTag("generalSubdivision").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("y").setBibframeTag("temporal").setMqTag("chronologicalSubdivision").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("z").setBibframeTag("geographic").setMqTag("geographicSubdivision").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setCompilanceLevels("O");
        this.getSubfield("2").setBibframeTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("4").setMqTag("relationship").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR")));
        this.sourceSpecificationType = SourceSpecificationType.Indicator2AndSubfield2;
        this.setHistoricalSubfields("b", "Geographic name following place entry element [OBSOLETE, 1981]");
    }
}

