/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag544
extends DataFieldDefinition {
    private static Tag544 uniqueInstance;

    private Tag544() {
        this.initialize();
        this.postCreation();
    }

    public static Tag544 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag544();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "544";
        this.label = "Location of Other Archival Materials Note";
        this.mqTag = "LocationOfOtherArchivalMaterials";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd544.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Relationship").setCodes(" ", "No information provided", "0", "Associated materials", "1", "Related materials").setMqTag("relationship");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Custodian", "R", "b", "Address", "R", "c", "Country", "R", "d", "Title", "R", "e", "Provenance", "R", "n", "Note", "R", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("custodian").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("address").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("country").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("d").setMqTag("title").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("provenance").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("n").setMqTag("note").setCompilanceLevels("O");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

