/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag526
extends DataFieldDefinition {
    private static Tag526 uniqueInstance;

    private Tag526() {
        this.initialize();
        this.postCreation();
    }

    public static Tag526 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag526();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "526";
        this.label = "Study Program Information Note";
        this.mqTag = "StudyProgram";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd526.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Display constant controller").setCodes("0", "Reading program", "8", "No display constant generated").setMqTag("displayConstant").setFrbrFunctions(FRBRFunction.ManagementDisplay);
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Program name", "NR", "b", "Interest level", "NR", "c", "Reading level", "NR", "d", "Title point value", "NR", "i", "Display text", "NR", "x", "Nonpublic note", "R", "z", "Public note", "R", "5", "Institution to which field applies", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("5").setCodeList(OrganizationCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("studyProgramName").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect).setCompilanceLevels("M");
        this.getSubfield("b").setBibframeTag("interestLevel").setFrbrFunctions(FRBRFunction.DiscoverySelect).setCompilanceLevels("A");
        this.getSubfield("c").setBibframeTag("readingLevel").setFrbrFunctions(FRBRFunction.DiscoverySelect).setCompilanceLevels("A");
        this.getSubfield("d").setBibframeTag("titlePoint").setFrbrFunctions(FRBRFunction.DiscoverySelect).setCompilanceLevels("A");
        this.getSubfield("i").setBibframeTag("displayText").setCompilanceLevels("O");
        this.getSubfield("x").setBibframeTag("nonpublicNote").setCompilanceLevels("O");
        this.getSubfield("z").setBibframeTag("publicNote").setCompilanceLevels("O");
        this.getSubfield("5").setMqTag("institutionToWhichFieldApplies").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

