/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.codelist.CitationSchemeSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag524
extends DataFieldDefinition {
    private static Tag524 uniqueInstance;

    private Tag524() {
        this.initialize();
        this.postCreation();
    }

    public static Tag524 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag524();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "524";
        this.label = "Preferred Citation of Described Materials Note";
        this.bibframeTag = "PreferredCitation";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd524.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Display constant controller").setCodes(" ", "Cite as", "8", "No display constant generated").setMqTag("displayConstant").setFrbrFunctions(FRBRFunction.ManagementDisplay);
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Preferred citation of described materials note", "NR", "2", "Source of schema used", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(CitationSchemeSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

