/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag514
extends DataFieldDefinition {
    private static Tag514 uniqueInstance;

    private Tag514() {
        this.initialize();
        this.postCreation();
    }

    public static Tag514 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag514();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "514";
        this.label = "Data Quality Note";
        this.mqTag = "DataQuality";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd514.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Attribute accuracy report", "NR", "b", "Attribute accuracy value", "R", "c", "Attribute accuracy explanation", "R", "d", "Logical consistency report", "NR", "e", "Completeness report", "NR", "f", "Horizontal position accuracy report", "NR", "g", "Horizontal position accuracy value", "R", "h", "Horizontal position accuracy explanation", "R", "i", "Vertical positional accuracy report", "NR", "j", "Vertical positional accuracy value", "R", "k", "Vertical positional accuracy explanation", "R", "m", "Cloud cover", "NR", "u", "Uniform Resource Identifier", "R", "z", "Display note", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("accuracyReport").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("accuracyValue").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("accuracyExplanation").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("logicalConsistency").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("completeness").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("horizontalPositionAccuracyReport").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("horizontalPositionAccuracyValue").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("h").setMqTag("horizontalPositionAccuracyExplanation").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("i").setMqTag("verticalPositionalAccuracyReport").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("j").setMqTag("verticalPositionalAccuracyValue").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("k").setMqTag("verticalPositionalAccuracyExplanation").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("m").setMqTag("cloudCover").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("u").setMqTag("uri").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("z").setMqTag("display").setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

