/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.validator.ISSNValidator;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag510
extends DataFieldDefinition {
    private static Tag510 uniqueInstance;

    private Tag510() {
        this.initialize();
        this.postCreation();
    }

    public static Tag510 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag510();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "510";
        this.label = "Citation/References Note";
        this.mqTag = "Citation";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd510.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Coverage/location in source").setCodes("0", "Coverage unknown", "1", "Coverage complete", "2", "Coverage is selective", "3", "Location in source not given", "4", "Location in source given").setMqTag("coverageOrLocationInSource");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Name of source", "NR", "b", "Coverage of source", "NR", "c", "Location within source", "NR", "u", "Uniform Resource Identifier", "R", "x", "International Standard Serial Number", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("x").setValidator(ISSNValidator.getInstance());
        this.getSubfield("a").setMqTag("name").setFrbrFunctions(FRBRFunction.DiscoverySelect).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("coverage").setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("location").setCompilanceLevels("A");
        this.getSubfield("u").setMqTag("uri").setCompilanceLevels("O");
        this.getSubfield("x").setMqTag("issn").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

