/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.codelist.AccessRestrictionTermSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag506
extends DataFieldDefinition {
    private static Tag506 uniqueInstance;

    private Tag506() {
        this.initialize();
        this.postCreation();
    }

    public static Tag506 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag506();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "506";
        this.label = "Restrictions on Access Note";
        this.bibframeTag = "UsageAndAccessPolicy";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd506.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Restriction").setCodes(" ", "No information provided", "0", "No restrictions", "1", "Restrictions apply").setMqTag("restriction");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Terms governing access", "NR", "b", "Jurisdiction", "R", "c", "Physical access provisions", "R", "d", "Authorized users", "R", "e", "Authorization", "R", "f", "Standardized terminology for access restriction", "R", "g", "Availability date", "R", "q", "Supplying agency", "NR", "u", "Uniform Resource Identifier", "R", "2", "Source of term", "NR", "3", "Materials specified", "NR", "5", "Institution to which field applies", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(AccessRestrictionTermSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("jurisdiction").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("physicalAccessProvisions").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("authorizedUsers").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("authorization").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("terminology").setCompilanceLevels("O");
        this.getSubfield("g").setMqTag("availabilityDate");
        this.getSubfield("q").setMqTag("supplyingAgency");
        this.getSubfield("u").setMqTag("uri").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("2").setMqTag("source").setCompilanceLevels("A");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("5").setMqTag("institutionToWhichFieldApplies").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

