/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag500
extends DataFieldDefinition {
    private static Tag500 uniqueInstance;

    private Tag500() {
        this.initialize();
        this.postCreation();
    }

    public static Tag500 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag500();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "500";
        this.label = "General Note";
        this.bibframeTag = "Note";
        this.mqTag = "GeneralNote";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd500.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "General note", "NR", "3", "Materials specified", "NR", "5", "Institution to which field applies", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdfs:label").setMqTag("rdf:value").setCompilanceLevels("M");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("5").setMqTag("institutionToWhichFieldApplies").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.setHistoricalSubfields("l", "Library of Congress call number (SE) [OBSOLETE, 1990]", "x", "International Standard Serial Number (SE) [OBSOLETE, 1990]", "z", "Source of note information (AM, SE) [OBSOLETE, 1990]");
    }
}

