/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags4xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.general.codelist.RelatorCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.validator.ISSNValidator;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag411
extends DataFieldDefinition {
    private static Tag411 uniqueInstance;

    private Tag411() {
        this.initialize();
        this.postCreation();
    }

    public static Tag411 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag411();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "411";
        this.label = "Series Statement/Added Entry Meeting Name";
        this.mqTag = "SeriesStatementAddedEntryMeetingName";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd411.html";
        this.ind1 = new Indicator("Type of meeting name entry element").setCodes("0", "Inverted name", "1", "Jurisdiction name", "2", "Name in direct order").setMqTag("type");
        this.ind2 = new Indicator("Pronoun represents main entry").setCodes("0", "Main entry not represented by pronoun", "9", "Main entry represented by pronoun").setMqTag("pronounRepresentsMainEntry");
        this.setSubfieldsWithCardinality("a", "Meeting name or jurisdiction name as entry element", "NR", "c", "Location of meeting", "NR", "d", "Date of meeting", "NR", "e", "Subordinate unit", "R", "f", "Date of a work", "NR", "g", "Miscellaneous information", "NR", "k", "Form subheading", "R", "l", "Language of a work", "NR", "n", "Number of part/section/meeting", "R", "p", "Name of part/section of a work", "R", "q", "Name of meeting following jurisdiction name entry element", "NR", "t", "Title of a work", "NR", "u", "Affiliation", "NR", "v", "Volume/sequential designation", "NR", "x", "International Standard Serial Number", "NR", "4", "Relator code", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("4").setCodeList(RelatorCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("x").setValidator(ISSNValidator.getInstance());
        this.getSubfield("a").setMqTag("rdf:value");
        this.getSubfield("c").setMqTag("locationOfMeeting");
        this.getSubfield("d").setMqTag("date");
        this.getSubfield("e").setMqTag("subordinateUnit");
        this.getSubfield("f").setMqTag("dateOfAWork");
        this.getSubfield("g").setMqTag("miscellaneous");
        this.getSubfield("k").setMqTag("formSubheading");
        this.getSubfield("l").setMqTag("languageOfAWork");
        this.getSubfield("n").setMqTag("numberOfPart");
        this.getSubfield("p").setMqTag("nameOfPart");
        this.getSubfield("q").setMqTag("nameOfMeeting");
        this.getSubfield("t").setMqTag("title");
        this.getSubfield("u").setMqTag("affiliation");
        this.getSubfield("v").setMqTag("volume");
        this.getSubfield("x").setMqTag("issn");
        this.getSubfield("4").setMqTag("relationship");
        this.getSubfield("6").setBibframeTag("linkage");
        this.getSubfield("8").setMqTag("fieldLink");
    }
}

