/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.MusicalInstrumentationAndVoiceSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag382
extends DataFieldDefinition {
    private static Tag382 uniqueInstance;

    private Tag382() {
        this.initialize();
        this.postCreation();
    }

    public static Tag382 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag382();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "382";
        this.label = "Medium of Performance";
        this.bibframeTag = "MusicMedium";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd382.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Display constant controller").setCodes(" ", "No information provided", "0", "Medium of performance", "1", "Partial medium of performance").setMqTag("displayConstant");
        this.ind2 = new Indicator("Access control").setCodes(" ", "No information provided", "0", "Not intended for access", "1", "Intended for access").setMqTag("accessControl");
        this.setSubfieldsWithCardinality("a", "Medium of performance", "R", "b", "Soloist", "R", "d", "Doubling instrument", "R", "e", "Number of ensembles of the same type", "R", "n", "Number of performers of the same medium", "R", "p", "Alternative medium of performance", "R", "r", "Total number of individuals performing alongside ensembles", "NR", "s", "Total number of performers", "NR", "t", "Total number of ensembles", "NR", "v", "Note", "R", "0", "Authority record control number or standard number", "R", "2", "Source of term", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(MusicalInstrumentationAndVoiceSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("Soloist");
        this.getSubfield("d").setMqTag("doublingInstrument");
        this.getSubfield("e").setMqTag("numberOfEnsembles");
        this.getSubfield("n").setMqTag("numberOfPerformers");
        this.getSubfield("p").setMqTag("alternativeMedium");
        this.getSubfield("r").setMqTag("totalNumberOfIndividuals");
        this.getSubfield("s").setMqTag("totalNumberOfPerformers");
        this.getSubfield("t").setMqTag("totalNumberOfEnsembles");
        this.getSubfield("v").setMqTag("note");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setCompilanceLevels("A");
        this.getSubfield("2").setMqTag("source").setCompilanceLevels("A");
        this.getSubfield("3").setMqTag("materialsSpecified");
        this.getSubfield("6").setBibframeTag("linkage").setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR")));
    }
}

