/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.LanguageCodeAndTermSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag377
extends DataFieldDefinition {
    private static Tag377 uniqueInstance;

    private Tag377() {
        this.initialize();
        this.postCreation();
    }

    public static Tag377 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag377();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "377";
        this.label = "Associated Language";
        this.mqTag = "AssociatedLanguage";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd377.html";
        this.ind1 = new Indicator();
        this.ind2 = new Indicator("Source of code").setCodes(" ", "MARC language code", "7", "Source specified in $2").setMqTag("sourceOfCode");
        this.setSubfieldsWithCardinality("a", "Language code", "R", "l", "Language term", "R", "0", "Authority record control number or standard number", "R", "2", "Source", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(LanguageCodeAndTermSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("languageCode");
        this.getSubfield("l").setMqTag("languageTerm");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber");
        this.getSubfield("2").setMqTag("source");
        this.getSubfield("6").setBibframeTag("linkage");
        this.getSubfield("8").setMqTag("fieldLink");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR")));
    }
}

