/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag347
extends DataFieldDefinition {
    private static Tag347 uniqueInstance;

    private Tag347() {
        this.initialize();
        this.postCreation();
    }

    public static Tag347 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag347();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "347";
        this.label = "Digital File Characteristics";
        this.bibframeTag = "DigitalCharacteristic";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd347.html";
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "File type", "R", "b", "Encoding format", "R", "c", "File size", "R", "d", "Resolution", "R", "e", "Regional encoding", "R", "f", "Encoded bitrate", "R", "0", "Authority record control number or standard number", "R", "2", "Source", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("fileType");
        this.getSubfield("b").setBibframeTag("encodingFormat");
        this.getSubfield("c").setBibframeTag("fileSize");
        this.getSubfield("d").setBibframeTag("resolution");
        this.getSubfield("e").setBibframeTag("regionalEncoding");
        this.getSubfield("f").setBibframeTag("encodedBitrate");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber");
        this.getSubfield("2").setBibframeTag("source");
        this.getSubfield("3").setMqTag("materialsSpecified");
        this.getSubfield("6").setBibframeTag("linkage");
        this.getSubfield("8").setMqTag("fieldLink");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR")));
    }
}

