/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag343
extends DataFieldDefinition {
    private static Tag343 uniqueInstance;

    private Tag343() {
        this.initialize();
        this.postCreation();
    }

    public static Tag343 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag343();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "343";
        this.label = "Planar Coordinate Data";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd343.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Planar coordinate encoding method", "NR", "b", "Planar distance units", "NR", "c", "Abscissa resolution", "NR", "d", "Ordinate resolution", "NR", "e", "Distance resolution", "NR", "f", "Bearing resolution", "NR", "g", "Bearing units", "NR", "h", "Bearing reference direction", "NR", "i", "Bearing reference meridian", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("method").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("distanceUnits").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("abscissa").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("ordinate").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("distance").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("bearingResolution").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("bearingUnits").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("h").setMqTag("bearingDirection").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("i").setMqTag("bearingMeridian").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

