/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag342
extends DataFieldDefinition {
    private static Tag342 uniqueInstance;

    private Tag342() {
        this.initialize();
        this.postCreation();
    }

    public static Tag342 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag342();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "342";
        this.label = "Geospatial Reference Data";
        this.mqTag = "GeospatialReferenceData";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd342.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator("Geospatial reference dimension").setCodes("0", "Horizontal coordinate system", "1", "Vertical coordinate system").setMqTag("dimension").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.ind2 = new Indicator("Geospatial reference method").setCodes("0", "Geographic", "1", "Map projection", "2", "Grid coordinate system", "3", "Local planar", "4", "Local", "5", "Geodetic model", "6", "Altitude", "7", "Method specified in $2", "8", "Depth").setMqTag("method");
        this.setSubfieldsWithCardinality("a", "Name", "NR", "b", "Coordinate units or distance units", "NR", "c", "Latitude resolution", "NR", "d", "Longitude resolution", "NR", "e", "Standard parallel or oblique line latitude", "R", "f", "Oblique line longitude", "R", "g", "Longitude of central meridian or projection center", "NR", "h", "Latitude of projection center or projection origin", "NR", "i", "False easting", "NR", "j", "False northing", "NR", "k", "Scale factor", "NR", "l", "Height of perspective point above surface", "NR", "m", "Azimuthal angle", "NR", "n", "Azimuth measure point longitude or straight vertical longitude from pole", "NR", "o", "Landsat number and path number", "NR", "p", "Zone identifier", "NR", "q", "Ellipsoid name", "NR", "r", "Semi-major axis", "NR", "s", "Denominator of flattening ratio", "NR", "t", "Vertical resolution", "NR", "u", "Vertical encoding method", "NR", "v", "Local planar, local, or other projection or grid description", "NR", "w", "Local planar or local georeference information", "NR", "2", "Reference method used", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("name").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("units").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("latitudeResolution").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("longitudeResolution").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("obliqueLineLatitude").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("obliqueLineLongitude").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("longitudeOfCentralMeridian").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("h").setMqTag("latitudeOfProjectionCenter").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("i").setMqTag("falseEasting").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("j").setMqTag("falseNorthing").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("k").setMqTag("scaleFactor").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("l").setMqTag("heightOfPerspective").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("m").setMqTag("azimuthalAngle").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("n").setMqTag("azimuthMeasurePoint").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("o").setMqTag("landsatNumber").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("p").setMqTag("zoneIdentifier").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("q").setMqTag("ellipsoidName").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("r").setMqTag("semiMajorAxis").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("s").setMqTag("denominatorOfFlatteningRatio").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("t").setMqTag("verticalResolution").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("u").setMqTag("verticalEncodingMethod").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("v").setMqTag("localProjection").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("w").setMqTag("georeference").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("2").setBibframeTag("source").setFrbrFunctions(FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

