/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;
import de.gwdg.metadataqa.marc.definition.structure.SubfieldDefinition;
import java.util.Arrays;

public class Tag340
extends DataFieldDefinition {
    private static Tag340 uniqueInstance;

    private Tag340() {
        this.initialize();
        this.postCreation();
    }

    public static Tag340 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag340();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "340";
        this.label = "Physical Medium";
        this.mqTag = "PhysicalMedium";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd340.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Material base and configuration", "R", "b", "Dimensions", "R", "c", "Materials applied to surface", "R", "d", "Information recording technique", "R", "e", "Support", "R", "f", "Production rate/ratio", "R", "g", "Color content", "R", "h", "Location within medium", "R", "i", "Technical specifications of medium", "R", "j", "Generation", "R", "k", "Layout", "R", "m", "Book format", "R", "n", "Font size", "R", "o", "Polarity", "R", "0", "Authority record control number or standard number", "R", "2", "Source", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("baseMaterial").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("b").setBibframeTag("dimensions").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain, FRBRFunction.UseOperate).setCompilanceLevels("A");
        this.getSubfield("c").setBibframeTag("appliedMaterial").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("productionMethod").setFrbrFunctions(FRBRFunction.DiscoverySelect, FRBRFunction.UseManage, FRBRFunction.UseOperate).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("mount").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("reductionRatio").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain, FRBRFunction.UseOperate).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("colorContent");
        this.getSubfield("h").setMqTag("location").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("i").setMqTag("systemRequirement").setFrbrFunctions(FRBRFunction.DiscoverySelect, FRBRFunction.UseOperate).setCompilanceLevels("A");
        this.getSubfield("j").setMqTag("generation");
        this.getSubfield("k").setMqTag("layout");
        this.getSubfield("m").setMqTag("bookFormat");
        this.getSubfield("n").setMqTag("fontSize");
        this.getSubfield("o").setMqTag("polarity");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber");
        this.getSubfield("2").setBibframeTag("source");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.putVersionSpecificSubfields(MarcVersion.NKCR, Arrays.asList(new SubfieldDefinition("7", "NKCR Authority ID", "NR")));
    }
}

