/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags25x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.codelist.RelatorCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag270
extends DataFieldDefinition {
    private static Tag270 uniqueInstance;

    private Tag270() {
        this.initialize();
        this.postCreation();
    }

    public static Tag270 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag270();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "270";
        this.label = "Address";
        this.mqTag = "Address";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd270.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Level").setCodes(" ", "No level specified", "1", "Primary", "2", "Secondary").setMqTag("level");
        this.ind2 = new Indicator("Type of address").setCodes(" ", "No type specified", "0", "Mailing", "7", "Type specified in subfield $i").setMqTag("type").setFrbrFunctions(FRBRFunction.ManagementIdentify);
        this.setSubfieldsWithCardinality("a", "Address", "R", "b", "City", "NR", "c", "State or province", "NR", "d", "Country", "NR", "e", "Postal code", "NR", "f", "Terms preceding attention name", "NR", "g", "Attention name", "NR", "h", "Attention position", "NR", "i", "Type of address", "NR", "j", "Specialized telephone number", "R", "k", "Telephone number", "R", "l", "Fax number", "R", "m", "Electronic mail address", "R", "n", "TDD or TTY number", "R", "p", "Contact person", "R", "q", "Title of contact person", "R", "r", "Hours", "R", "z", "Public note", "R", "4", "Relationship", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("4").setCodeList(RelatorCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoveryObtain, FRBRFunction.ManagementDisplay).setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("city").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("state").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("d").setMqTag("country").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("e").setMqTag("postalCode").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("f").setMqTag("precedingTerms").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("g").setMqTag("attentionName").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("h").setMqTag("attentionPosition").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("i").setMqTag("typeOfAddress").setFrbrFunctions(FRBRFunction.ManagementDisplay).setCompilanceLevels("A");
        this.getSubfield("j").setMqTag("specializedPhone").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("k").setMqTag("phone").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("l").setMqTag("fax").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("m").setMqTag("email").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("n").setMqTag("tddOrTty").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("p").setMqTag("contactPerson").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("q").setMqTag("contactPersonTitle").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("r").setMqTag("hours").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("z").setMqTag("note").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("4").setMqTag("relationship").setCompilanceLevels("O");
        this.getSubfield("6").setMqTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

