/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags25x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag260
extends DataFieldDefinition {
    private static Tag260 uniqueInstance;

    private Tag260() {
        this.initialize();
        this.postCreation();
    }

    public static Tag260 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag260();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "260";
        this.label = "Publication, Distribution, etc. (Imprint)";
        this.bibframeTag = "Publication";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd260.html";
        this.setCompilanceLevels("A", "A");
        this.ind1 = new Indicator("Sequence of publishing statements").setCodes(" ", "Not applicable/No information provided/Earliest available publisher", "2", "Intervening publisher", "3", "Current/latest publisher").setHistoricalCodes("0", "Publisher, distributor, etc. is present", "1", "Publisher, distributor, etc. not present").setMqTag("sequenceOfPublishingStatements").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain);
        this.ind2 = new Indicator().setHistoricalCodes("0", "Publisher, distributor, etc. not same as issuing body in added entry", "1", "Publisher, distributor, etc. same as issuing body in added entry");
        this.setSubfieldsWithCardinality("a", "Place of publication, distribution, etc.", "R", "b", "Name of publisher, distributor, etc.", "R", "c", "Date of publication, distribution, etc.", "R", "e", "Place of manufacture", "R", "f", "Manufacturer", "R", "g", "Date of manufacture", "R", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("place").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("b").setBibframeTag("agent").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("c").setBibframeTag("date").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("e").setMqTag("placeOfManufacture").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("manufacturer").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("dateOfManufacture").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("3").setMqTag("materialsSpecified").setCompilanceLevels("O");
        this.getSubfield("6").setMqTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.setHistoricalSubfields("d", "Plate or publisher's number for music (Pre-AACR2) [OBSOLETE, 1981] [CAN/MARC only] / Plate or publisher's number for music (Pre-AACR2) [OBSOLETE, 1999] [USMARC only]", "k", "Identification/manufacturer number [OBSOLETE, 1988] [CAN/MARC only]", "l", "Matrix and/or take number [OBSOLETE, 1988] [CAN/MARC only]");
    }
}

