/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags25x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.structure.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.structure.Indicator;

public class Tag250
extends DataFieldDefinition {
    private static Tag250 uniqueInstance;

    private Tag250() {
        this.initialize();
        this.postCreation();
    }

    public static Tag250 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag250();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "250";
        this.label = "Edition Statement";
        this.mqTag = "Edition";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd250.html";
        this.setCompilanceLevels("A", "A");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Edition statement", "NR", "b", "Remainder of edition statement", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("editionStatement").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M", "M");
        this.getSubfield("b").setMqTag("remainder").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("3").setMqTag("materialsSpecified");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

